% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{replace_nonfinite}
\alias{replace_nonfinite}
\alias{\%f|\%}
\title{Replace non-finite values with other value (finite-OR-operator)}
\usage{
a \%f|\% b
}
\arguments{
\item{a}{atomic vector of any type.}

\item{b}{single value to replace non-finite values with.}
}
\value{
If values in \code{a} are non-finite, they are replaced with \code{b},
otherwise they are left unchanged.
}
\description{
Used internally, helper function that replaces non-finite (i.e., \code{NA}, \code{NaN},
\code{Inf}, and \code{-Inf}) values according to \code{\link[=is.finite]{is.finite()}}, primarily used to
replace \code{NaN}/\code{Inf}/\code{-Inf} with \code{NA}.
}
\keyword{internal}
