% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_results.R
\name{extract_results_batch}
\alias{extract_results_batch}
\title{Extract results from a batch of trials from an object with multiple trials}
\usage{
extract_results_batch(
  trial_results,
  control = control,
  select_strategy = select_strategy,
  select_last_arm = select_last_arm,
  select_preferences = select_preferences,
  te_comp = te_comp,
  which_ests = which_ests,
  te_comp_index = te_comp_index,
  te_comp_true_y = te_comp_true_y
)
}
\arguments{
\item{trial_results}{list of trial results to summarise, the current batch.}

\item{control}{single character string, the common \code{control} arm from the
trial specification (\code{NULL} if none).}

\item{select_strategy}{single character string. If a trial was not stopped
due to superiority (or had only 1 arm remaining, if \code{select_last_arm} is
set to \code{TRUE} in trial designs with a common \code{control} arm; see below),
this parameter specifies which arm will be considered selected when
calculating trial design performance metrics, as described below;
this corresponds to the consequence of an inconclusive trial, i.e., which
arm would then be used in practice.\cr
The following options are available and must be written exactly as below
(case sensitive, cannot be abbreviated):
\itemize{
\item \code{"control if available"} (default): selects the \strong{first}
\code{control} arm for trials with a common \code{control} arm \emph{\strong{if}} this
arm is active at end-of-trial, otherwise no arm will be selected. For
trial designs without a common \code{control}, no arm will be selected.
\item \code{"none"}: selects no arm in trials not ending with superiority.
\item \code{"control"}: similar to \code{"control if available"}, but will throw
an error if used for trial designs without a common \code{control} arm.
\item \code{"final control"}: selects the \strong{final} \code{control} arm regardless
of whether the trial was stopped for practical equivalence, futility,
or at the maximum sample size; this strategy can only be specified
for trial designs with a common \code{control} arm.
\item \code{"control or best"}: selects the \strong{first} \code{control} arm if still
active at end-of-trial, otherwise selects the best remaining arm
(defined as the remaining arm with the highest probability of being
the best in the last adaptive analysis conducted). Only works for
trial designs with a common \code{control} arm.
\item \code{"best"}: selects the best remaining arm (as described under
\code{"control or best"}).
\item \code{"list or best"}: selects the first remaining arm from a specified
list (specified using \code{select_preferences}, technically a character
vector). If none of these arms are are active at end-of-trial, the best
remaining arm will be selected (as described above).
\item \code{"list"}: as specified above, but if no arms on the provided list
remain active at end-of-trial, no arm is selected.
}}

\item{select_last_arm}{single logical, defaults to \code{FALSE}. If \code{TRUE}, the
only remaining active arm (the last \code{control}) will be selected in trials
with a common \code{control} arm ending with \code{equivalence} or \code{futility}, before
considering the options specified in \code{select_strategy}. Must be \code{FALSE} for
trial designs without a common \code{control} arm.}

\item{select_preferences}{character vector specifying a number of arms used
for selection if one of the \code{"list or best"} or \code{"list"} options are
specified for \code{select_strategy}. Can only contain valid \code{arms}
available in the trial.}

\item{te_comp}{character string, treatment-effect comparator. Can be either
\code{NULL} (the default) in which case the \strong{first} \code{control} arm is used for
trial designs with a common control arm, or a string naming a single trial
\code{arm}. Will be used when calculating \code{sq_err_te} (the squared error of the
treatment effect comparing the selected arm to the comparator arm, as
described below).}

\item{which_ests}{single character string, a combination of the \code{raw_ests}
and \code{final_ests} arguments from \code{\link[=extract_results]{extract_results()}}.}

\item{te_comp_index}{single integer, index of the treatment effect comparator
arm (\code{NULL} if none).}

\item{te_comp_true_y}{single numeric value, true \code{y} value in the treatment
effect comparator arm (\code{NULL} if none).}
}
\value{
A \code{data.frame} containing all columns returned by \code{\link[=extract_results]{extract_results()}}
and described in that function (\code{sim} will start from \code{1}, but this is
changed where relevant by \code{\link[=extract_results]{extract_results()}}).
}
\description{
Used internally by \code{\link[=extract_results]{extract_results()}}. Extracts results from a batch of
simulations from a simulation object with multiple simulation results
returned by \code{\link[=run_trials]{run_trials()}}, used to facilitate parallelisation.
}
\keyword{internal}
