% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_trial.R
\name{run_trial}
\alias{run_trial}
\title{Simulate a single trial}
\usage{
run_trial(trial_spec, seed = NULL, sparse = FALSE)
}
\arguments{
\item{trial_spec}{\code{trial_spec} object, generated and validated by the
\code{\link[=setup_trial]{setup_trial()}}, \code{\link[=setup_trial_binom]{setup_trial_binom()}} or \code{\link[=setup_trial_norm]{setup_trial_norm()}} function.}

\item{seed}{single integer or \code{NULL} (default). If a value is provided, this
value will be used as the random seed when running and the global random
seed will be restored after the function has run, so it is not affected.}

\item{sparse}{single logical; if \code{FALSE} (default) everything listed below is
included in the returned object. If \code{TRUE}, only a limited amount of data
is included in the returned object. This can be practical when running many
simulations and saving the results using the \code{\link[=run_trials]{run_trials()}} function (which
relies on this function), as the output file will thus be substantially
smaller. However, printing of individual trial results will be
substantially less detailed for sparse results and non-sparse results are
required by \code{\link[=plot_history]{plot_history()}}.}
}
\value{
A \code{trial_result} object containing everything listed below if
\code{sparse} (as described above) is \code{FALSE}. Otherwise only \code{final_status},
\code{final_n}, \code{followed_n}, \code{trial_res}, \code{seed}, and \code{sparse} are included.
\itemize{
\item \code{final_status}: either \code{"superiority"}, \code{"equivalence"},
\code{"futility"}, or \code{"max"} (stopped at the last possible adaptive
analysis), as calculated during the adaptive analyses.
\item \code{final_n}: the total number of patients randomised.
\item \code{followed_n}: the total number of patients with available outcome
data at the last adaptive analysis conducted.
\item \code{max_n}: the pre-specified maximum number of patients with outcome
data available at the last possible adaptive analysis.
\item \code{max_randomised}: the pre-specified maximum number of patients
randomised at the last possible adaptive analysis.
\item \code{looks}: numeric vector, the total number of patients with outcome
data available at each conducted adaptive analysis.
\item \code{planned_looks}: numeric vector, the cumulated number of patients
planned to have outcome data available at each adaptive analysis, even
those not conducted if the simulation is stopped before the final
possible analysis.
\item \code{randomised_at_looks}: numeric vector, the total number of patients
randomised at each conducted adaptive analysis.
\item \code{start_control}: character, initial common control arm (if
specified).
\item \code{final_control}: character, final common control arm (if relevant).
\item \code{control_prob_fixed}: fixed common control arm probabilities (if
specified; see \code{\link[=setup_trial]{setup_trial()}}).
\item \code{inferiority}, \code{superiority}, \code{equivalence_prob},
\code{equivalence_diff}, \code{equivalence_only_first}, \code{futility_prob},
\code{futility_diff}, \code{futility_only_first}, \code{highest_is_best}, and
\code{soften_power}: as specified in \code{\link[=setup_trial]{setup_trial()}}.
\item \code{best_arm}: the best arm(s), as described in \code{\link[=setup_trial]{setup_trial()}}.
\item \code{trial_res}: a \code{data.frame} containing most of the information
specified for each arm in \code{\link[=setup_trial]{setup_trial()}} including \code{true_ys} (true
outcomes as specified in \code{\link[=setup_trial]{setup_trial()}}) and for each arm the sum of
the outcomes (\code{sum_ys}/\code{sum_ys_all}; i.e., the total number of events
for binary outcomes or the totals of continuous outcomes) and sum of
patients (\code{ns}/\code{ns_all}), summary statistics for the raw outcome data
(\code{raw_ests}/\code{raw_ests_all}, calculated as specified in \code{\link[=setup_trial]{setup_trial()}},
defaults to mean values, i.e., event rates for binary outcomes or means
for continuous outcomes) and posterior estimates
(\code{post_ests}/\code{post_ests_all}, \code{post_errs}/\code{post_errs_all},
\code{lo_cri}/\code{lo_cri_all}, and \code{hi_cri}/\code{hi_cri_all}, calculated as
specified in \code{\link[=setup_trial]{setup_trial()}}), \code{final_status} of each arm
(\code{"inferior"}, \code{"superior"}, \code{"equivalence"}, \code{"futile"}, \code{"active"},
or \code{"control"} (currently active control arm, including if the current
control when stopped for equivalence)), \code{status_look} (specifying the
cumulated number of patients with outcome data available when an
adaptive analysis changed the \code{final_status} to \code{"superior"},
\code{"inferior"}, \code{"equivalence"}, or \code{"futile"}), \code{status_probs}, the
probability (in the last adaptive analysis for each arm) that each
arm was the best/better than the common control arm (if any)/equivalent
to the common control arm (if any and stopped for equivalence; \code{NA} if
the control arm was stopped due to the last remaining other arm(s)
being stopped for equivalence)/futile if stopped for futility at the
last analysis it was included in, \code{final_alloc}, the final allocation
probability for each arm the last time patients were randomised to it,
including for arms stopped at the maximum sample size, and
\code{probs_best_last}, the probabilities of each remaining arm being the
overall best in the last conducted adaptive analysis (\code{NA} for
previously dropped arms).\cr
\strong{Note:} for the variables in the \code{data.frame} where a version
including the \verb{_all}-suffix is included, the versions WITHOUT this
suffix are calculated using patients with available outcome data at the
time of analysis, while the versions WITH the \verb{_all}-suffixes are
calculated using outcome data for all patients randomised at the time
of analysis, even if they have not reached the time of follow-up yet
(see \code{\link[=setup_trial]{setup_trial()}}).
\item \code{all_looks}: a list of lists containing one list per conducted
trial look (adaptive analysis). These lists contain the variables
\code{arms}, \code{old_status} (status before the analysis of the current round
was conducted), \code{new_status} (as specified above, status after current
analysis has been conducted), \code{sum_ys}/\code{sum_ys_all} (as described
above), \code{ns}/\code{ns_all} (as described above), \code{old_alloc} (the allocation
probability used during this look), \code{probs_best} (the probabilities of
each arm being the best in the current adaptive analysis), \code{new_alloc}
(the allocation probabilities after updating these in the current
adaptive analysis; NA for all arms when the trial is stopped and no
further adaptive analyses will be conducted), \code{probs_better_first} (if
a common control is provided, specifying the probabilities that each
arm was better than the control in the first analysis conducted during
that look), \code{probs_better} (as \code{probs_better_first}, but updated if
another arm becomes the new control), \code{probs_equivalence_first} and
\code{probs_equivalence} (as for \code{probs_better}/\code{probs_better_first}, but
for equivalence if equivalence is assessed). The last variables are
\code{NA} if the arm was not active in the applicable adaptive analysis or
if they would not be included during the next adaptive analysis.
\item \code{allocs}: a character vector containing the allocations of all
patients in the order of randomization.
\item \code{ys}: a numeric vector containing the outcomes of all patients in
the order of randomization (\code{0} or \code{1} for binary outcomes).
\item \code{seed}: the random seed used, if specified.
\item \code{description}, \code{add_info}, \code{cri_width}, \code{n_draws}, \code{robust}: as
specified in \code{\link[=setup_trial]{setup_trial()}}, \code{\link[=setup_trial_binom]{setup_trial_binom()}} or
\code{\link[=setup_trial_norm]{setup_trial_norm()}}.
\item \code{sparse}: single logical, corresponding to the \code{sparse} input.
}
}
\description{
This function conducts a single trial simulation using a trial specification
as specified by \code{\link[=setup_trial]{setup_trial()}}, \code{\link[=setup_trial_binom]{setup_trial_binom()}} or
\code{\link[=setup_trial_norm]{setup_trial_norm()}}.
During simulation, the function randomises "patients", randomly generates
outcomes, calculates the probabilities that each \code{arm} is the best (and
better than the control, if any). This is followed by checking inferiority,
superiority, equivalence and/or futility as desired; dropping arms, and
re-adjusting allocation probabilities according to the criteria specified in
the trial specification. If there is no common \code{control} arm, the trial
simulation will be stopped at the final specified adaptive analysis, when 1
arm is superior to the others, or when all arms are considered equivalent (if
equivalence testing is specified).\cr
If a common \code{control} arm is specified, all other arms will be compared to
that, and if 1 comparison crosses the applicable superiority threshold at an
adaptive analysis, that arm will become the new control and the old control
will be considered inferior. If multiple non-control arms cross the
applicable superiority threshold in the same adaptive analysis, the one with
the highest probability of being the overall best will become the new
control. Equivalence/futility will also be checked if specified, and
equivalent or futile arms will be dropped in designs with a common \code{control}
arm and the entire trial will be stopped if all remaining arms are equivalent
in designs without a common \code{control} arm. The trial simulation will be
stopped when only 1 arm is left, when the final arms are all equivalent, or
after the final specified adaptive analysis.\cr
After stopping (regardless of reason), a final analysis including outcome
data from all patients randomised to all arms will be conducted (with the
final \code{control} arm, if any, used as the \code{control} in this analysis).
Results from this analysis will be saved, but not used with regards to the
adaptive stopping rules. This is particularly relevant if less patients have
available outcome data at the adaptive analyses than the total number of
patients randomised (as specified in \code{\link[=setup_trial]{setup_trial()}}, \code{\link[=setup_trial_binom]{setup_trial_binom()}},
or \code{\link[=setup_trial_norm]{setup_trial_norm()}}), as the final analysis will then include all
patients randomised, which may be more than in the last adaptive analysis
conducted.
}
\examples{
# Setup a trial specification
binom_trial <- setup_trial_binom(arms = c("A", "B", "C", "D"),
                                 true_ys = c(0.20, 0.18, 0.22, 0.24),
                                 data_looks = 1:20 * 100)

# Run trial with a specified random seed
res <- run_trial(binom_trial, seed = 12345)

# Print results with 3 decimals
print(res, digits = 3)

}
