% Generated by roxygen2 (4.0.2): do not edit by hand
\docType{data}
\name{matthews2013}
\alias{matthews2013}
\title{Data from Experiment 1 in Matthews (2013)}
\format{A data.frame with 216 rows and 3 variables.}
\source{
Matthews, W. (2013). Relatively random: Context effects on perceived randomness and predicted outcomes. \emph{Journal of Experimental Psychology: Learning, Memory, and Cognition}, 39(5), 1642-1648.
}
\usage{
matthews2013
}
\description{
Mean responses on a 6-point scale ("definitely random" to "definitely not random") of participants to 216 strings of length 21.
}
\examples{

\dontrun{
data(matthews2013)

spans <- 3:11
# note, the next loop takes more than 5 minutes.
for (i in spans) {
  matthews2013[,paste0("K2_span", i)] <- 
    sapply(local_complexity(matthews2013$string, alphabet=2, span = i), mean)
}

lm_list <- vector("list", 8)
for (i in seq_along(spans)) {
  lm_list[[i]] <- lm(as.formula(paste0("mean ~ K2_span", spans[i])), matthews2013)
}

plot(spans, sapply(lm_list, function(x) summary(x)$r.squared), type = "o")

# do more predictors increase fit?
require(MASS)
m_initial <- lm(mean ~ 1, matthews2013)
m_step <- stepAIC(m_initial, 
                  scope = as.formula(paste("~", paste(paste0("K2_span", spans), 
                  collapse = "+"))))
summary(m_step)

m_initial2 <- lm(as.formula(paste("mean ~", paste(paste0("K2_span", spans), 
                  collapse = "+"))), matthews2013)
m_step2 <- stepAIC(m_initial2)
summary(m_step2)

}
}
\keyword{dataset}

