% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pprior.R
\name{pprior}
\alias{pprior}
\title{Prior Cumulative Distribution Function (CDF)}
\usage{
pprior(q, prior_par = list(mu_psi = 0, sigma_psi = 1, mu_beta = 0,
  sigma_beta = 1), what = "logor", hypothesis = "H1")
}
\arguments{
\item{q}{numeric vector with quantiles.}

\item{prior_par}{list with prior parameters. This list needs to contain the
following elements: \code{mu_psi} (prior mean for the normal prior on the
test-relevant log odds ratio), \code{sigma_psi} (prior standard deviation
for the normal prior on the test-relevant log odds ratio), \code{mu_beta}
(prior mean for the normal prior on the grand mean of the log odds),
\code{sigma_beta} (prior standard deviation for the normal prior on the
grand mean of the log odds). Each of the elements needs to be a real number
(the standard deviations need to be positive). The default are standard
normal priors for both the log odds ratio parameter and the grand mean of
the log odds parameter.}

\item{what}{character specifying for which quantity the prior CDF should be
evaluated. Either \code{"logor"} (i.e., log odds ratio) , \code{"or"}
(i.e., odds ratio), \code{"rrisk"} (i.e., relative risk, the ratio of the
"success" probability in the experimental and the control condition), or
\code{"arisk"} (i.e., absolute risk, the difference of the "success"
probability in the experimental and control condition).}

\item{hypothesis}{character specifying whether to evaluate the CDF for a
two-sided prior (i.e., "H1"), a one-sided prior with lower truncation point
(i.e., "H+"), or a one-sided prior with upper truncation point (i.e.,
"H-").}
}
\value{
numeric vector with the values of the prior CDF.
}
\description{
Function for evaluating the prior cumulative distribution function (CDF).
}
\note{
Internally, the test-relevant prior is always a normal prior on the log
  odds ratio, consequently, if \code{what} is not \code{"logor"}, the
  implied prior CDF for the quantity is returned.
}
\examples{
# prior parameters
prior_par <- list(mu_psi = 0, sigma_psi = 1,
                  mu_beta = 0, sigma_beta = 1)

# evaluate prior CDF
pprior(q = 0.1, prior_par = prior_par, what = "logor")
pprior(q = 1.1, prior_par = prior_par, what = "or")
pprior(q = 1.05, prior_par = prior_par, what = "rrisk")
pprior(q = 0.02, prior_par = prior_par, what = "arisk")

# also works for vectors
pprior(q = c(-0.1, 0, 0.1, 0.2), prior_par = prior_par, what = "logor")
}
\author{
Quentin F. Gronau
}
