% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ab_scenario.R
\name{ab_json}
\alias{ab_json}
\title{Convert geographic ('sf') representation of OD data to 'JSON list' structure}
\usage{
ab_json(
  desire_lines_out,
  mode_column = NULL,
  time_fun = ab_time_normal,
  scenario_name,
  ...
)
}
\arguments{
\item{desire_lines_out}{OD data represented as geographic lines created by
\code{\link[=ab_scenario]{ab_scenario()}}.}

\item{mode_column}{The column name in the desire lines data that contains
the mode of transport. \code{"mode_baseline"} by default.}

\item{time_fun}{The function used to calculate departure times.
\code{ab_time_normal()} by default.}

\item{scenario_name}{The name of the scenario to appear in A/B Street}

\item{...}{Additional arguments to pass to \code{\link[=ab_json]{ab_json()}}}
}
\value{
A list that can be saved as a JSON file with \code{\link[=ab_save]{ab_save()}}
}
\description{
This function takes outputs from \code{\link[=ab_scenario]{ab_scenario()}} and returns a list that
can be saved as a JSON file for import into A/B Street.
}
\details{
Note: the departure time in seconds is multiplied by 10000 on conversion
to a .json list object for compatibility with the A/B Street schema.
}
\examples{
od = leeds_od
od[[1]] = c("E02006876")
zones = leeds_zones
ablines = ab_scenario(od, zones = zones)
ab_list = ab_json(ablines, mode_column = "mode", scenario_name = "test")
ab_list$scenario
f = tempfile(fileext = ".json")
ab_save(ab_list, f)
readLines(f)[1:30]
}
