\name{BFD_Processor}
\alias{double knockout result processor}
\alias{BFD_Processor}
\title{BFD_Processor, a Bi-Flux-Del-Processor function}

\description{
BFD_Processor reassembles the "result(n)" files created by Exhaustive_double_deletion, 
the result files should be a complete set from 1-n and put in a folder BKO 
in pwd before execution. The output is a tab delimited spreadsheet Fatal_Double_knockouts_unique.xls
}

\usage{
	BFD_Processor(fba_object,EXSDR)
}

\arguments{
\item{fba_object}{Is a list containing the data required to perform flux
balance analysis. The elements of the list are mat which is the 
stoichiometric matrix, dir which gives the direction of the equality 
constraints, obj specifies the objective function for the simulation, 
bounds specifies the lower and upper inequality constraints, rhs is the 
right hand side of the steady state expression, types refers to the 
numeric nature of the variables which in case of FBA happens to be 
"Continuous", max is a Boolean specifying the type of optimization,
"Maximization" by default, all_genes is all the genes present in the 
model, gpr contains boolean expressions of gene essentiality for the 
corresponding reactions in the model, metabolite_name contains list of 
all the metabolites, reaction_list contains all the reactions present in
the model, compartment is a numeric identifier for each reaction the key
for which is in comp_name.}

\item{EXSDR}{A list of the type generated by the Exhaustive_single_deletion function, this list 
may be passed to this function or the function will generate the list on its own. It is used for 
removing the results of lethal single knockouts which will form pairs with all other knockouts 
leading to false positives of double synthetic lethality.}

}
\examples{
#Function to process the results of the double knockout
#data(Ecoli_core)	
#BFD_Processor(Ecoli_core,EXSDR=Exhaustive_single_deletion_results)	
# A prompt will appear asking for the number of simulation pieces 
#and also to make sure you have your results filled in a folder 
#called BKO in the present working directory.
}
