% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Equidigital.R
\name{Equidigital}
\alias{Equidigital}
\alias{A046758}
\title{Equidigital numbers}
\usage{
Equidigital(n, gmp = TRUE)
}
\arguments{
\item{n}{the number of first \code{n} entries from the sequence.}

\item{gmp}{a logical; \code{TRUE} to use large number representation, \code{FALSE} otherwise.}
}
\value{
a vector of length \code{n} containing first entries from the sequence.
}
\description{
Under OEIS \href{https://oeis.org/A046758}{A046758}, an \emph{Equidigital} number has equal digits
as the number of digits in its prime factorization including exponents. First 6 Equidigital numbers are 1, 2, 3, 5, 7, 10. Though
it doesn't matter which base we use, here we adopt only a base of 10.
}
\examples{
## generate first 20 Equidigital numbers
print(Equidigital(20))

}
\seealso{
\code{\link{Frugal}}, \code{\link{Extravagant}}
}
