% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetSearchResults.R
\name{GetSearchResults}
\alias{GetSearchResults}
\title{Make request to Zillow API GetSearchResults Web Service}
\usage{
GetSearchResults(
  address = NULL,
  citystatezip = NULL,
  rentzestimate = FALSE,
  zws_id = getOption("ZillowR-zws_id"),
  url = "http://www.zillow.com/webservice/GetSearchResults.htm"
)
}
\arguments{
\item{address}{The address of the property to search. Required.}

\item{citystatezip}{The city+state combination and/or ZIP code for which to
search. Required.}

\item{rentzestimate}{Return Rent Zestimate information if available (logical,
default: false).}

\item{zws_id}{The Zillow Web Service Identifier. Required.}

\item{url}{URL for the GetSearchResults Web Service. Required.}
}
\value{
A named list with the following elements:
\describe{
\item{\strong{request}}{a list with the request parameters}
\item{\strong{message}}{a list of status code(s) and message(s)
returned by the API}
\item{\strong{response}}{an XMLNode with the API-specific response
values. At this time, no further coercion is performed, so you
may have to use functions from the \code{XML} package to extract
the desired output.}
}
}
\description{
The GetSearchResults API finds a property for a specified address. The
content returned contains the address for the property or properties as well
as the Zillow Property ID (ZPID) and current Zestimate. It also includes the
date the Zestimate was computed, a valuation range and the Zestimate ranking
for the property within its ZIP code.
}
\examples{
\dontrun{
GetSearchResults(address = '2114 Bigelow Ave', citystatezip = 'Seattle, WA')
GetSearchResults(address = '2114 Bigelow Ave', citystatezip = 'Seattle, WA',
                 rentzestimate = TRUE)}
}
