/*
 * Decompiled with CFR 0.152.
 */
package com.miraisolutions.xlconnect.data;

import com.miraisolutions.xlconnect.Common;
import com.miraisolutions.xlconnect.ErrorBehavior;
import com.miraisolutions.xlconnect.Workbook;
import com.miraisolutions.xlconnect.data.DataType;
import com.miraisolutions.xlconnect.utils.CellUtils;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FormulaEvaluator;

public final class ColumnBuilder
extends Common {
    private ArrayList<DataType> detectedTypes;
    private ArrayList<Cell> cells;
    private ArrayList<CellValue> values;
    private String dateTimeFormat;
    private boolean forceConversion;
    private boolean takeCached = false;
    private FormulaEvaluator evaluator = null;
    private ErrorBehavior onErrorCell;
    private String[] missingValueStrings;
    private double[] missingValueNumbers;

    /*
     * WARNING - void declaration
     */
    public ColumnBuilder(int nrows, boolean forceConversion, FormulaEvaluator evaluator, ErrorBehavior onErrorCell, Object[] missingValue) {
        void var2_4;
        int i;
        this.detectedTypes = new ArrayList(nrows);
        this.cells = new ArrayList(nrows);
        this.values = new ArrayList(nrows);
        this.forceConversion = forceConversion;
        this.evaluator = evaluator;
        this.takeCached = evaluator == null;
        this.onErrorCell = onErrorCell;
        ArrayList<Double> missingNum = new ArrayList<Double>();
        ArrayList<String> missingStr = new ArrayList<String>();
        for (i = 0; i < missingValue.length; ++i) {
            if (missingValue[i] instanceof String) {
                missingStr.add((String)missingValue[i]);
                continue;
            }
            if (!(missingValue[i] instanceof Double)) continue;
            missingNum.add((Double)missingValue[i]);
        }
        this.missingValueStrings = missingStr.toArray(new String[var2_4.size()]);
        this.missingValueNumbers = new double[missingNum.size()];
        for (i = 0; i < missingNum.size(); ++i) {
            this.missingValueNumbers[i] = (Double)missingNum.get(i);
        }
    }

    private void addMissing() {
        this.values.add(null);
        this.cells.add(null);
        this.detectedTypes.add(DataType.Boolean);
    }

    /*
     * WARNING - void declaration
     */
    private void cellError(String msg) {
        void var1_1;
        if (this.onErrorCell.equals((Object)ErrorBehavior.WARN)) {
            this.addMissing();
            this.addWarning(msg);
            return;
        }
        throw new IllegalArgumentException((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void addCell(Cell c) {
        void var1_1;
        CellValue cv;
        Object object;
        String msg;
        if (c == null) {
            this.addMissing();
            return;
        }
        if (c.getCellType() == 5 || c.getCellType() == 2 && c.getCachedFormulaResultType() == 5) {
            msg = "Error detected in cell " + CellUtils.formatAsString(c) + " - " + CellUtils.getErrorMessage(c.getErrorCellValue());
            this.cellError(msg);
            return;
        }
        try {
            CellValue cellValue;
            block27: {
                void var3_2;
                block26: {
                    var3_2 = msg;
                    object = this;
                    if (!((ColumnBuilder)object).takeCached) break block26;
                    object = var3_2;
                    int n = object.getCellType();
                    if (n == 2) {
                        n = object.getCachedFormulaResultType();
                    }
                    switch (n) {
                        case 3: {
                            cellValue = null;
                            break block27;
                        }
                        case 4: {
                            cellValue = object.getBooleanCellValue() ? CellValue.TRUE : CellValue.FALSE;
                            break block27;
                        }
                        case 0: {
                            cellValue = new CellValue(object.getNumericCellValue());
                            break block27;
                        }
                        case 1: {
                            cellValue = new CellValue(object.getStringCellValue());
                            break block27;
                        }
                        case 5: {
                            cellValue = CellValue.getError((int)object.getErrorCellValue());
                            break block27;
                        }
                        default: {
                            object = String.format("Could not extract value from cell with cached value type %d", n);
                            throw new RuntimeException((String)object);
                        }
                    }
                }
                cellValue = ((ColumnBuilder)object).evaluator.evaluate((Cell)var3_2);
            }
            cv = cellValue;
        }
        catch (Exception e) {
            msg = "Error when trying to evaluate cell " + CellUtils.formatAsString((Cell)msg) + " - " + e.getMessage();
            this.cellError(msg);
            return;
        }
        if (cv == null) {
            this.addMissing();
            return;
        }
        switch (cv.getCellType()) {
            case 3: {
                this.addMissing();
                return;
            }
            case 4: {
                this.addValue((Cell)msg, cv, DataType.Boolean);
                return;
            }
            case 0: {
                if (DateUtil.isCellDateFormatted((Cell)msg)) {
                    this.addValue((Cell)msg, cv, DataType.DateTime);
                    return;
                }
                boolean missing = false;
                for (int i = 0; i < this.missingValueNumbers.length; ++i) {
                    if (cv.getNumberValue() != this.missingValueNumbers[i]) continue;
                    missing = true;
                    break;
                }
                if (missing) {
                    this.addMissing();
                    return;
                }
                this.addValue((Cell)msg, cv, DataType.Numeric);
                return;
            }
            case 1: {
                void var3_6;
                boolean missing = false;
                for (int i = 0; i < this.missingValueStrings.length; ++i) {
                    if (cv.getStringValue() != null && !cv.getStringValue().equals(this.missingValueStrings[i])) continue;
                    missing = true;
                    break;
                }
                if (var3_6 != false) {
                    this.addMissing();
                    return;
                }
                this.addValue((Cell)msg, cv, DataType.String);
                return;
            }
            case 2: {
                msg = "Formula detected in already evaluated cell " + CellUtils.formatAsString((Cell)msg) + "!";
                this.cellError(msg);
                return;
            }
            case 5: {
                msg = "Error detected in cell " + CellUtils.formatAsString((Cell)msg) + " - " + CellUtils.getErrorMessage(object.getErrorValue());
                this.cellError(msg);
                return;
            }
        }
        msg = "Unexpected cell type detected for cell " + CellUtils.formatAsString((Cell)msg) + "!";
        this.cellError((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void addValue(Cell c, CellValue cv, DataType dt) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.cells.add((Cell)var1_1);
        this.values.add((CellValue)var2_2);
        this.detectedTypes.add((DataType)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public final DataType determineColumnType() {
        void var1_1;
        DataType columnType = DataType.Boolean;
        Iterator<DataType> it = this.detectedTypes.iterator();
        while (it.hasNext() && !columnType.equals((Object)DataType.String)) {
            void var3_3;
            DataType dt = it.next();
            if (dt.ordinal() <= columnType.ordinal()) continue;
            columnType = var3_3;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final ArrayList build(DataType asType) {
        void var2_2;
        DataType columnType;
        columnType = asType == null ? this.determineColumnType() : columnType;
        ArrayList<Object> colValues = new ArrayList<Object>(this.values.size());
        Iterator<CellValue> it = this.values.iterator();
        Iterator<Cell> jt = this.cells.iterator();
        DataFormatter fmt = new DataFormatter();
        int counter = 0;
        while (it.hasNext()) {
            CellValue cv = it.next();
            Cell cell = jt.next();
            if (cv == null) {
                colValues.add(null);
            } else {
                block2 : switch (columnType) {
                    case Boolean: {
                        switch (this.detectedTypes.get(counter)) {
                            case Boolean: {
                                colValues.add(cv.getBooleanValue());
                                break block2;
                            }
                            case Numeric: {
                                if (this.forceConversion) {
                                    colValues.add(cv.getNumberValue() > 0.0);
                                    break block2;
                                }
                                colValues.add(null);
                                break block2;
                            }
                            case String: {
                                if (this.forceConversion) {
                                    colValues.add(Boolean.valueOf(cv.getStringValue().toLowerCase()));
                                    break block2;
                                }
                                colValues.add(null);
                                break block2;
                            }
                            case DateTime: {
                                colValues.add(null);
                                this.addWarning("Cell " + CellUtils.formatAsString(this.cells.get(counter)) + " cannot be converted from DateTime to Boolean - returning NA");
                                break block2;
                            }
                        }
                        throw new IllegalArgumentException("Unknown data type detected!");
                    }
                    case DateTime: {
                        switch (this.detectedTypes.get(counter)) {
                            case Boolean: {
                                colValues.add(null);
                                this.addWarning("Cell " + CellUtils.formatAsString(this.cells.get(counter)) + " cannot be converted from Boolean to DateTime - returning NA");
                                break block2;
                            }
                            case Numeric: {
                                if (this.forceConversion) {
                                    if (DateUtil.isValidExcelDate((double)cv.getNumberValue())) {
                                        colValues.add(DateUtil.getJavaDate((double)cv.getNumberValue()));
                                        break block2;
                                    }
                                    colValues.add(null);
                                    this.addWarning("Cell " + CellUtils.formatAsString(this.cells.get(counter)) + " cannot be converted from Numeric to DateTime - returning NA");
                                    break block2;
                                }
                                colValues.add(null);
                                break block2;
                            }
                            case String: {
                                if (this.forceConversion) {
                                    try {
                                        colValues.add(Workbook.dateTimeFormatter.parse(cv.getStringValue(), this.dateTimeFormat));
                                    }
                                    catch (Exception exception) {
                                        colValues.add(null);
                                        this.addWarning("Cell " + CellUtils.formatAsString(this.cells.get(counter)) + " cannot be converted from String to DateTime - returning NA");
                                    }
                                    break block2;
                                }
                                colValues.add(null);
                                break block2;
                            }
                            case DateTime: {
                                colValues.add(DateUtil.getJavaDate((double)cv.getNumberValue()));
                                break block2;
                            }
                        }
                        throw new IllegalArgumentException("Unknown data type detected!");
                    }
                    case Numeric: {
                        switch (this.detectedTypes.get(counter)) {
                            case Boolean: {
                                colValues.add(cv.getBooleanValue() ? 1.0 : 0.0);
                                break block2;
                            }
                            case Numeric: {
                                colValues.add(cv.getNumberValue());
                                break block2;
                            }
                            case String: {
                                if (this.forceConversion) {
                                    try {
                                        colValues.add(Double.parseDouble(cv.getStringValue()));
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        colValues.add(null);
                                        this.addWarning("Cell " + CellUtils.formatAsString(this.cells.get(counter)) + " cannot be converted from String to Numeric - returning NA");
                                    }
                                    break block2;
                                }
                                colValues.add(null);
                                break block2;
                            }
                            case DateTime: {
                                if (this.forceConversion) {
                                    colValues.add(cv.getNumberValue());
                                    break block2;
                                }
                                colValues.add(null);
                                break block2;
                            }
                        }
                        throw new IllegalArgumentException("Unknown data type detected!");
                    }
                    case String: {
                        switch (this.detectedTypes.get(counter)) {
                            case Boolean: 
                            case Numeric: {
                                colValues.add(fmt.formatCellValue(cell, this.evaluator));
                                break block2;
                            }
                            case DateTime: {
                                colValues.add(Workbook.dateTimeFormatter.format(DateUtil.getJavaDate((double)cv.getNumberValue()), this.dateTimeFormat));
                                break block2;
                            }
                            case String: {
                                colValues.add(cv.getStringValue());
                                break block2;
                            }
                        }
                        throw new IllegalArgumentException("Unknown data type detected!");
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown column type detected!");
                    }
                }
            }
            ++counter;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final void setDateTimeFormat(String format) {
        void var1_1;
        this.dateTimeFormat = var1_1;
    }
}

