% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/metadata.R
\name{page_info}
\alias{page_info}
\title{Retrieve information about a particular page}
\usage{
page_info(language = NULL, project = NULL, domain = NULL, page,
  properties = c("protection", "talkid", "url", "displaytitle"),
  clean_response = FALSE, ...)
}
\arguments{
\item{language}{The language code of the project you wish to query,
if appropriate.}

\item{project}{The project you wish to query ("wikiquote"), if appropriate.
Should be provided in conjunction with \code{language}.}

\item{domain}{as an alternative to a \code{language} and \code{project} combination,
you can also provide a domain ("rationalwiki.org") to the URL constructor, allowing
for the querying of non-Wikimedia MediaWiki instances.}

\item{page}{the title of the page you want the metadata of.}

\item{properties}{the properties you'd like to retrieve. Some properties (the pageID, namespace,
title, language, length and most recent revision ID, for example) are retrieved by default,
whatever is passed to \code{properties}: properties that can be explicitly retrieved include
the page's protection level ("protection"), the ID of the associated talk page, if applicable
("talkid"), the full, canonical URL ("url"), and the displayed page title ("displaytitle").}

\item{clean_response}{whether to do some basic sanitising of the resulting data structure.
Set to FALSE by default.}

\item{...}{further arguments to pass to httr's GET.}
}
\description{
page_info, when provided with a page title, retrieves metadata about that page.
}
\examples{
#Metadata
page_metadata <- page_info("en","wikipedia", page = "Aaron Halfaker")
}

