% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DistributionPlot.R
\name{PlotDistDensityBeta}
\alias{PlotDistDensityBeta}
\title{Plot empirical rate data as a density with the matching beta distribution}
\usage{
PlotDistDensityBeta(
  frm,
  xvar,
  title,
  ...,
  curve_color = "lightgray",
  beta_color = "blue",
  mean_color = "blue",
  sd_color = "darkgray"
)
}
\arguments{
\item{frm}{data frame to get values from}

\item{xvar}{name of the independent (input or model) column in frame}

\item{title}{title to place on plot}

\item{...}{force later arguments to bind by name}

\item{curve_color}{color for empirical density curve}

\item{beta_color}{color for matching theoretical beta}

\item{mean_color}{color for mean line}

\item{sd_color}{color for 1-standard deviation lines (can be NULL)}
}
\description{
Compares empirical rate data to a beta distribution with the same mean and standard deviation.
}
\details{
Plots the empirical density, the theoretical matching beta, the mean value,
and plus/minus one standard deviation from the mean.
}
\examples{

set.seed(52523)
N = 100
pgray = 0.1  # rate of gray horses in the population
herd_size = round(runif(N, min=25, 50))
ngray = rbinom(N, herd_size, pgray)
hdata = data.frame(n_gray=ngray, herd_size=herd_size)

# observed rate of gray horses in each herd
hdata$rate_gray = with(hdata, ngray/herd_size)

title = "Observed prevalence of gray horses in population"

PlotDistDensityBeta(hdata, "rate_gray", title) +
  ggplot2::geom_vline(xintercept = pgray, linetype=4, color="maroon") +
  ggplot2::annotate("text", x=pgray+0.01, y=0.01, hjust="left",
                    label = paste("True prevalence =", pgray))

# no sd lines
PlotDistDensityBeta(hdata, "rate_gray", title,
                    sd_color=NULL)
}
