% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LiftCurve.R
\name{LiftCurvePlot}
\alias{LiftCurvePlot}
\title{Plot the cumulative lift curve of a sort-order.}
\usage{
LiftCurvePlot(
  frame,
  xvar,
  truthVar,
  title,
  ...,
  large_count = 1000,
  include_wizard = TRUE,
  truth_target = NULL,
  model_color = "darkblue",
  wizard_color = "darkgreen"
)
}
\arguments{
\item{frame}{data frame to get values from}

\item{xvar}{name of the independent (input or model score) column in frame}

\item{truthVar}{name of the dependent (output or result to be modeled) column in frame}

\item{title}{title to place on plot}

\item{...}{no unnamed argument, added to force named binding of later arguments.}

\item{large_count}{numeric, upper bound target for number of plotting points}

\item{include_wizard}{logical, if TRUE plot the ideal or wizard plot.}

\item{truth_target}{if not NULL compare to this scalar value.}

\item{model_color}{color for the model curve}

\item{wizard_color}{color for the "wizard" (best possible) curve}
}
\description{
Plot the cumulative lift curve of a sort-order.
}
\details{
The use case for this visualization is to compare a predictive model
score to an actual outcome (either binary (0/1) or continuous). In this case the
lift curve plot measures how well the model score sorts the data compared
to the true outcome value.

The x-axis represents the fraction of items seen when sorted by score, and the
y-axis represents the lift seen so far (cummulative value of model over cummulative value of random selection)..

For comparison, \code{LiftCurvePlot} also plots the "wizard curve": the lift curve when the
data is sorted according to its true outcome.

To improve presentation quality, the plot is limited to approximately \code{large_count} points (default: 1000).
For larger data sets, the data is appropriately randomly sampled down before plotting.
}
\examples{

set.seed(34903490)
y = abs(rnorm(20)) + 0.1
x = abs(y + 0.5*rnorm(20))
frm = data.frame(model=x, value=y)
WVPlots::LiftCurvePlot(frm, "model", "value",
   title="Example Continuous Lift Curve")

}
