% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Euler.R
\name{17. Euler's phi function}
\alias{17. Euler's phi function}
\alias{phi}
\alias{phi.default}
\alias{phi.numeric}
\alias{phi.vli}
\title{Euler's Phi Function for vli Objects}
\usage{
phi(x)

\method{phi}{default}(x)

\method{phi}{numeric}(x)

\method{phi}{vli}(x)
}
\arguments{
\item{x}{positive integer; object of class vli or 32 bits integer}
}
\value{
object of class vli
}
\description{
Euler's Phi Function for vli (Very Large Integers) objects. Given a positive integer \code{x}, the Euler's Phi Function returns the number of positive integers up to \code{x} that are relatively prime to \code{x}.
}
\details{
The returned value by the \code{phi} function is equal to the order of the group of units of the ring \code{Z/Zn} (the multiplicative group of integers modulo \code{n}). It is also called Euler's Totient Function, and plays a major part in Number Theory and in the RSA Cryptosystem.
}
\examples{
\dontrun{
x <- as.vli("24352")
phi(x)
}
}
\author{
Javier Leiva Cuadrado
}
