% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varbundle.R
\name{varbundle}
\alias{varbundle}
\title{Create bundle of variables.}
\usage{
varbundle(x)
}
\arguments{
\item{x}{(list or data.frame)}
}
\value{
(VarBundle)
}
\description{
VarBundle objects store read-only variables in a list-like
structure. Variable values can be accessed via the `$` operator
(\code{vb$foobar}) or via field name(\code{vb[["foobar"]]}).
After a VarBundle object has been created, new fields cannot be added
and existing field values cannot be modified.

Field names can be accessed via \code{\link{field_names}}.

Simple VarBundle objects that only contain atomic, scalar values are
useful for storing configuration information. The object method
\code{$as.data.frame()} will return a data.frame version of the VarBundle.
This can be persisted to disk and subsequently modified by the end user
to change system parameters.
}
\examples{
# Access via $
sales <- varbundle(list(min = 1, max = 10))
sales$min

# Access via name
my_var <- field_names(sales)[1]
sales[[my_var]]

# Create data.frame
df <- sales$as.data.frame()

# Create VarBundle from data.frame
corp_sales <- varbundle(df)
class(corp_sales)

}
