% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dlCvrt.R
\name{dl2ts}
\alias{dl2ts}
\title{Convert a double list to tensor}
\usage{
dl2ts(x)
}
\arguments{
\item{x}{A double list to be converted.}
}
\value{
Return a tensor filled with the binding character elements.
}
\description{
Convert a double list to a tensor. The pure numeric layers will be sorted intrinsically then all
elements will be bound in certain order as one character element, and filled into the proper location in the tensor.
}
\examples{
#Make column names of datatest into double list:
dl <- chrvec2dl(colnames(datatest), "-")

#Convert the double list to a tensor:
dl2ts(dl)
}
\seealso{
\code{\link[VBTree:dl2vbt]{dl2vbt}}, \code{\link[VBTree:dl2arr]{dl2arr}}.
}
\keyword{Double.List}
\keyword{tensor}
