% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arrCvrt.R
\name{arr2dl}
\alias{arr2dl}
\title{Convert a structured character array to double list}
\usage{
arr2dl(x, ...)
}
\arguments{
\item{x}{A structured character array to be converted.}

\item{...}{Argument in \code{\link[VBTree:chrvec2dl]{chrvec2dl}} to control split pattern.}
}
\value{
Return a double list based on the input array.
}
\description{
Convert a structured character array to a double list. All character elements in array will be splited by
a specific pattern then sorted intrinsically in each layer of the double list.
}
\examples{
#Write the column names of datatest into a array:
arr <- dl2arr(chrvec2dl(colnames(datatest)))

#Recover the double list from character array:
arr2dl(arr)
}
\seealso{
\code{\link[VBTree:arr2vbt]{arr2vbt}}, \code{\link[VBTree:chrvec2dl]{chrvec2dl}}.
}
\keyword{Double.List}
\keyword{array}
