% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stage_uncertainty.R
\name{stage_uncertainty}
\alias{stage_uncertainty}
\title{Stage uncertainty}
\usage{
stage_uncertainty(data, var_name, stages = setdiff(names(data),
  var_name))
}
\arguments{
\item{data}{a data frame containing scenarios(factor or character) for each stages and the variable of interest(numeric).
data should contain all combinations of scenarios. columns scenarios}

\item{var_name}{the name of the variable of interest}

\item{stages}{names of the stages in the model.}
}
\value{
List of 4 elements
\item{summary}{summary of uncertainties}
\item{main_uncer}{a vector of uncertainties from the main effects of the stages}
\item{int_uncer}{a vector of uncertainties from the interaction effects of the stages}
\item{scenario_uncer}{a vector of uncertainties of the stages}
}
\description{
This function performs uncertainty decomposition by stage based on the second order interaction ANOVA model.
The uncertainty from interaction effect from two stages is divided equally and assigned to each stage.
}
\examples{
stage1 <- LETTERS[1:3]
stage2 <- LETTERS[1:2]
stage3 <- LETTERS[1:4]
y <- rnorm(3*2*4)
data <- expand.grid(stage1=stage1,
                    stage2=stage2,
                    stage3=stage3)
data <- cbind(data, y)
# stage_uncertainty(data,"y", names(data)[-4])
}
