% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{extract_grid}
\alias{extract_grid}
\title{Extracting and Aggregation of the UKgrid Dataset}
\usage{
extract_grid(type = "tsibble", columns = "ND", start = NULL,
  end = NULL, aggregate = NULL, weekly_agg = "index", na.rm = TRUE)
}
\arguments{
\item{type}{A character, define the output type - c(`tsibble`,`xts`, `zoo`, `ts`, `mts`, `data.frame`, `tbl`, `data.table`)}

\item{columns}{Selecting the columns names to be used from the UKgrid dataset,
can be either the numeric values of the columns index, or a string with the column names. Please see below the field descriptions}

\item{start}{Defines the starting date and time of the data extractions,
could be either an integer with the year value (4-digits format) or Date/POSIXt obejct}

\item{end}{Defines the ending date and time of the data extractions,
could be either an integer with the year value (4-digits format) or Date/POSIXt obejct}

\item{aggregate}{A string, if not NULL (default) aggregate up the series.
possible aggregation options are c("hourly", "daily", "weekly", "monthly", "quarterly", "yearly")}

\item{weekly_agg}{A string, define the week count methodology (according to the lubridate \code{\link[lubridate]{week}} functions setting)
to be used when the aggregation of the series set to weekly.
Possible options "index" (default), "week", "isoweek", or "epiweek".}

\item{na.rm}{A boolean, if TRUE will use the na.rm function to ignore any missing values in the aggregation process}
}
\description{
Extracting and Aggregation of the UKgrid Dataset
}
\details{
Field descriptions, source National Grid UK \href{https://www.nationalgrid.com/uk}{website}

TIMESTAMP - a POSIXt object (if not aggregate to daily frequency and above), the time stamp of the series observations

ND - National Demand, National Demand is calculated as a sum of generation based on National Grid operational generation metering

I014_ND - Equivalent to ND (above) but calculated using settlement metered generation data from the I014 file where available

TSD - Transmission System Demand, This is the Transmission System generation requirement and is equivalent to the Initial Transmission System Outturn (ITSDO) and Transmission System Demand Forecast on BM Reports. Transmission System Demand is equal to the ND plus the additional generation required to meet station load, pump storage pumping and interconnector exports

I014_TSD - Equivalent to TSD (above), but calculated using settlement metered generation data from the I014 file where available

ENGLAND_WALES_DEMAND - England and Wales Demand, as ND above but on an England and Wales basis

EMBEDDED_WIND_GENERATION - Estimated Embedded Wind Generation, This is an estimate of the GB wind generation from wind farms which do not have Transmission System metering installed. These wind farms are embedded in the distribution network and invisible to National Grid. Their effect is to suppress the electricity demand during periods of high wind. The true output of these generators is not known so an estimate is provided based on National Grid’s best model

EMBEDDED_WIND_CAPACITY - Estimated Embedded Wind Capacity, This is National Grid’s best view of the installed embedded wind capacity in GB. This is based on publically available information compiled from a variety of sources and is not the definitive view. It is consistent with the generation estimate provided above

EMBEDDED_SOLAR_GENERATION - Estimated Embedded Solar Generation, As embedded wind generation above, but for solar generation

EMBEDDED_SOLAR_CAPACITY - Embedded Solar Capacity, As embedded wind capacity above, but for solar generation
}
\examples{
df <- extract_grid(type = "tsibble", columns = "ND", start = 2017)

}
