% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UBStats_Main_Visible_ALL_202406.R
\name{LM.output}
\alias{LM.output}
\title{Extract Model Residuals and other Regression Diagnostics}
\usage{
LM.output(object, data)
}
\arguments{
\item{object}{An object returned by function lm.}

\item{data}{An optional data frame containing the data
frame possibly specified in the call of function lm.}
}
\value{
A dataframe containing the variables in the model
and the model's fitted values, residuals
and influence statistics, merged with the dataframe
specified in the call of function lm, or with the
dataframe possibly specified in \code{data}
(if it is consistent with the model's output)
}
\description{
\code{LM.output()}  Provides fitted values, residuals and other basic
quantities used to check the quality of regression fits.
}
\examples{
data(MktDATA, package = "UBStats")

# Model and output based on a given dataframe
mod1 <- lm(TotVal ~ Baseline + Kids + Age, data = MktDATA)
# Equivalent calls (since data is specified in lm() 
mod1_out <- LM.output(mod1, data = MktDATA)
dim(mod1_out)
mod1_out <- LM.output(mod1)
dim(mod1_out) # same as above

# Model based on a dataframe's columns
mod2 <- lm(MktDATA$TotVal ~ MktDATA$Baseline + 
           MktDATA$Kids + MktDATA$Age)
mod2_out <- LM.output(mod2)
# note: colnames in mod2_out
colnames(mod2_out)
# note that the dataframe in 'data' is not considered
# as compatible, because the names of columns differ
mod2_out <- LM.output(mod2, data = MktDATA)

}
\author{
Raffaella Piccarreta \email{raffaella.piccarreta@unibocconi.it}
}
