% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_lda.R
\name{predict_lda}
\alias{predict_lda}
\title{Predict topics of tweets using fitted LDA model}
\usage{
predict_lda(
  data,
  lda_model,
  response = "max",
  remove_numbers = TRUE,
  remove_punct = TRUE,
  remove_symbols = TRUE,
  remove_url = TRUE
)
}
\arguments{
\item{data}{Data frame of parsed tweets. Obtained either by using \code{\link{load_tweets}}  or
\code{\link[jsonlite]{stream_in}} in conjunction with \code{\link[rtweet]{tweets_with_users}}.}

\item{lda_model}{Fitted LDA Model. Object of class \link[topicmodels:TopicModel-class]{LDA}.}

\item{response}{Type of response. Either "prob" for probabilities or "max" one topic (default).}

\item{remove_numbers}{Logical. If \code{TRUE} remove tokens that consist only of numbers,
but not words that start with digits, e.g. 2day. See \link[quanteda]{tokens}.}

\item{remove_punct}{Logical. If \code{TRUE} remove all characters in the Unicode
"Punctuation" [P] class, with exceptions for those used as prefixes for valid social media tags if
\code{preserve_tags = TRUE}. See \link[quanteda]{tokens}}

\item{remove_symbols}{Logical. If \code{TRUE} remove all characters in the Unicode "Symbol" [S] class.}

\item{remove_url}{Logical. If \code{TRUE} find and eliminate URLs beginning with http(s).}
}
\value{
Data frame of topic predictions or predicted probabilities per topic (see response).
}
\description{
Predict topics of tweets using fitted LDA model.
}
\examples{
\dontrun{

library(Twitmo)

# load tweets (included in package)
mytweets <- load_tweets(system.file("extdata", "tweets_20191027-141233.json", package = "Twitmo"))

# Pool tweets into longer pseudo-documents
pool <- pool_tweets(data = mytweets)
pooled_dfm <- pool$document_term_matrix

# fit your LDA model with 7 topics
model <- fit_lda(pooled_dfm, n_topics = 7, method = "Gibbs")

# Predict topics of tweets using your fitted LDA model
predict_lda(mytweets, model, response = "prob")
}
}
