% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.decomp.R
\name{check.decomp}
\alias{check.decomp}
\title{Diagnostic tools to inspect SSA decomposition for mean sea level records.}
\usage{
check.decomp(object, station_name = " ", option = 1, comps = " ",
  trend = c(1), DOF = " ", wdir = " ", save_file = "FALSE")
}
\arguments{
\item{object}{an annual average mean sea level time series (refer \code{\link[stats]{ts}})
with water levels (in millimetres). Objects of class "gap.fillview" can also be parsed
directly to this function (refer \code{\link{gap.fillview}}).

\strong{Warning: } Input data files are not permitted to contain missing values
in order to perform necessary Singular Spectrum Analysis (SSA) or other spectral
functions. If the input files contain missing data, the analysis will be
terminated. For this reason, this function permits the direct use of objects
from the \code{\link{gap.fillview}} function. Similarly, the analysis will be
terminated if input files are less than 30 years in length. Whilst it is not
generally recommended to use time series less than 80 years in length for mean
sea level analyses (Watson, 2018)(and a warning will appear accordingly), it
is recognised that this collection of diagnostic tools are valuable for decomposing
and understanding the type of signals present in shorter datasets.}

\item{station_name}{character string, providing the name of the data record.

\strong{Note: }This field can be left blank, however, it is retained for use
in banner labelling of plotting and associated outputs.}

\item{option}{numeric, provides a range of diagnostic tools for inspecting
mean sea level time series. Available options include:

\itemize{
  \item 1: A tabular summary is displayed of the spectral density distribution within
  each component from an SSA decomposition of the time series (refer \code{\link[Rssa]{ssa}}
  with default settings). Values are based on a spectogram of individual components
  (refer \code{\link[stats]{spec.pgram}}). This table can be used to readily
  identify the frequency bands associated with the peak spectral density
  for each component. Trends are readily identfiable as components in
  which the peak spectral density resides in the lowest frequency band.
  This tabular summary can be exported direct to the working directory
  by setting the "save_file" argument to "TRUE" where the file will be
  saved as "spec_summary.csv". Option 1 is the default setting;
  \item 2: A tabular summary is displayed based on the spectral density
  distribution observed via Option 1 (above) converted to percentages which are
  based on the sum of the spectral density for each component. This analysis
  can be used to gain an insight into the proportion of energy residing
  in each frequency band for each component. This tabular summary can be
  exported direct to the working directory by setting the "save_file"
  argument to "TRUE" where the file will be saved as "spec_summary_percent.csv";
  \item 3: A screen plot of the components from the SSA decomposition.
  A tabular summary of the component time series can be exported direct to
  the working directory by setting the "save_file" argument to "TRUE" where
  the file will be saved as "comps_timeseries.csv";
  \item 4: A screen plot of the relative contribution of each component
  from the SSA decomposition in the low frequency band [0-0.01]. A tabular summary
  of the relative contributions can be exported direct to the working
  directory by setting the "save_file" argument to "TRUE" where the file
  will be saved as "low_freq_contributions.csv";
  \item 5: A screen plot to look at the sensitivity of the smoothing
  parameter for the cubic smoothing spline fitted to the trend in order
  to estimate mean sea level velocity and acceleration over the
  length of the record. The function requires the trend components to
  be advised via the "trend" argument and similarly, the degrees of
  freedom for the fitted spline to be input via the "DOF" argument.
  Defaults are provided for both the "trend" and "DOF" if not supplied.
  Refer further details on each argument. A tabular summary
  of the time series of both the trend and the fitted smooth spline can
  be exported direct to the working directory by setting the "save_file"
  argument to "TRUE" where the file will be saved as "trend_smooth.csv";
}}

\item{comps}{numeric, enables the user to specify the number of components to be
considered or displayed with this range of diagnostic tools. The default is the
maximum number available within the \code{\link[Rssa]{ssa}} function of the
\code{\link{Rssa}} package, which in turn is governed by the length of the
time series (maximum possible is 50). \strong{This parameter is only
used in options 1 to 3.}}

\item{trend}{numeric, enables the user to select the trend components
directly in the form of a single component or multiple components (eg.,
c(1) or c(1,2,3)). The default setting is c(1) as the first component will
always be trend, however, other components might also have trend characteristics
which can be diagnostically observed via options 1 to 4. \strong{This parameter is only
used in option 5.}}

\item{DOF}{numeric, enables the user to optimise the degrees of freedom
for the fitted cubic smoothing spline applied to the trend. The default
setting is based on 1 degree of freedom every 8 years (Watson, 2018) and
this default is written to the console to enable the user to directly compare
with manually entered DOF. \strong{This parameter is only used in option 5.}}

\item{wdir}{character string, providing the name of the directory to send
output files (e.g., \dQuote{C:/myproject/}) when the save_file argument is set to "TRUE".
If this field is left blank the save_file argument is switched off and a message
will be sent to the console.}

\item{save_file}{logical, if "TRUE". Default setting is "FALSE". Refer individual
option setting for detail on the respective files that are saved.}
}
\description{
Diagnostic tools to inspect SSA decomposition for mean sea level records.
}
\details{
This function provides a range of visual diagnostic tools to screen
check SSA decomposition of the time series prior to undertaking the customised
trend analysis (refer \code{\link{custom.trend}}). This function permits
inspection of the components from the SSA decomposition to inform
selection of appropriate components to comprise the trend and to optimise
selection of the degrees of freedom (DOF) for the fitted cubic smoothing
spline which estimates velocity and acceleration for use in \code{\link{custom.trend}}.
}
\examples{
# -------------------------------------------------------------------------
# View application of different diagnostic tools for Baltimore mean sea level record.
# -------------------------------------------------------------------------

data(Balt) # Baltimore mean sea level record
ts1 <- ts(Balt[2], start = Balt[1, 1]) # create time series input object

g <- gap.fillview(ts1, station_name = "Baltimore", fillgaps = 1) # SSA filled gap

check.decomp(g, option = 3) # check screen plot, default settings
check.decomp(g, option = 3, comps = 10) # check screen plot
check.decomp(g, option = 4) # check screen plot
check.decomp(g, option = 5) # check screen plot, default settings
check.decomp(g, option = 5, trend = c(1,2), DOF = 20) # check screen plot
check.decomp(g, option = 5, trend = c(1,2,3), DOF = 30) # check screen plot

}
\references{
Watson, P.J., 2018. \emph{Improved Techniques to Estimate Mean Sea Level,
Velocity and Acceleration from Long Ocean Water Level Time Series to Augment
Sea Level (and Climate Change) Research.} PhD Thesis, University of New South
Wales, Sydney, Australia.
}
\seealso{
\code{\link{custom.trend}}, \code{\link[stats]{ts}}, \code{\link{gap.fillview}},
\code{\link[Rssa]{ssa}}, \code{\link[stats]{spec.pgram}}.
}
