% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.TLSW.R
\name{plot.TLSW}
\alias{plot.TLSW}
\title{Plot Trend and/or Spectrum Information in a \code{TLSW} Object}
\usage{
\method{plot}{TLSW}(
  x,
  plot.type = c("trend", "spec"),
  trend.plot.args,
  spec.plot.args,
  plot.CI = TRUE,
  ...
)
}
\arguments{
\item{x}{A \code{TLSW} object}

\item{plot.type}{A string object indicating what is to be plotted. Can be:
\itemize{
   \item \code{"trend"}: will plot the trend estimate only.
   \item \code{"spec"}: will plot the spectral estimate only.
   \item \code{c("trend", "spec")}: the default value will plot both the trend and spectral estimate.
}}

\item{trend.plot.args}{A list object, that includes any choices for the graphical parameters used for plotting the trend estimate.}

\item{spec.plot.args}{A list object, that includes any choices for the graphical parameters used for plotting the spectral estimate.}

\item{plot.CI}{A logical variable. If TRUE, the confidence interval of the trend estimate (if computed) will be included in the plot.}

\item{...}{Any additional arguments that will be applied to the graphical parameters of both the trend and spectrum plotting.}
}
\value{
No return value, called for side effects
}
\description{
Plots information contained within a \code{TLSW} object.
Depending on the \code{plot.type} option this will produce a plot of the data
with trend estimate overlayed, a plot of the spectral estimate, or both (default).
If the \code{TLSW} object does not contain trend or spectral estimates and these are requested
a warning will be given.
}
\details{
A TLSW object can be plotted using the standard \code{plot} function in R to display the
estimated trend function and wavelet spectrum. The estimated trend is visualised using
\code{\link[graphics]{plot.default}}. Visualisation of the estimated spectrum is
based on \code{\link[wavethresh]{plot.wd}}, for which credit belongs to Guy Nason.
Graphical parameters for customising the display of the trend or spectrum plots should be given
to the \code{trend.plot.args} and \code{spec.plot.args} arguments respectively.
For graphical parameters for the trend plot:
\itemize{
\item Parameters related to the overall plot should be provided as they usually would be when using the \code{plot} function,
in the \code{trend.plot.args} list object. For example, to change the title of the plot to "Plot", use \code{main = "Plot"}.
\item Parameters affecting the display of the estimated trend line should begin with the
prefix \code{"T."}. For example, to set the colour of the trend line to blue, use
\code{T.col = "blue"}.
\item Parameters affecting the display of the confidence interval lines should begin with the
prefix \code{"CI."}. For example, to set the line width of the confidence interval to 2, use
\code{CI.lwd = 2}.
\item Parameters affecting the display of the polygon drawn by the confidence interval
 should begin with the prefix \code{"poly."}. For example, to set the colour of the
 confidence interval region to green, use \code{poly.col = "green"}.
}
}
\examples{
# Simulates an example time series and estimates its trend and evolutionary wavelet spectrum.
# Then plots both estimates.

spec <- matrix(0, nrow = 9, ncol = 512)

spec[1, ] <- 4 + 4 * sin(seq(from = 0, to = 2 * pi, length = 512))^2

trend <- seq(from = 0, to = 10, length = 512) + 2 * sin(seq(from = 0, to = 2 * pi, length = 512))

set.seed(1)

x <- TLSWsim(trend = trend, spec = spec)

x.TLSW <- TLSW(x)

plot(x.TLSW, trend.plot.args = list(
  ylab = "Simulated Data", T.col = 4,
  T.lwd = 2, T.lty = 2
))

}
\references{
McGonigle, E. T., Killick, R., and Nunes, M. (2022). Modelling
time-varying first and second-order structure of time series via wavelets
and differencing. \emph{Electronic Journal of Statistics}, 6(2), 4398-4448.

McGonigle, E. T., Killick, R., and Nunes, M. (2022). Trend
locally stationary wavelet processes. \emph{Journal of Time Series
Analysis}, 43(6), 895-917.
}
\seealso{
\code{\link{TLSW}}, \code{\link{summary.TLSW}}, \code{\link{print.TLSW}}, \code{\link[wavethresh]{plot.wd}}
}
