\name{TreeSim-package}
\alias{TreeSim-package}
\alias{TreeSim}
\docType{package}
\title{
TreeSim: Simulating phylogenetic trees}
\description{
The package simulates phylogenetic trees where (i) all tips are sampled at one time point or (ii) tips are sampled sequentially through time. (i) For sampling at one time point, simulations are performed under a constant-rate birth-death process, conditioned on having a fixed number of final tips (sim.bd.taxa), or a fixed age (sim.bd.age), or a fixed age and number of tips (sim.bd.taxa.age). When conditioning on the number of final tips, the method allows for shifts in rates and mass extinction events during the birth-death process (sim.rateshift.taxa).sim.bd.age (and sim.rateshift.taxa without extinction) allow the speciation rate to change in a density-dependent way. The LTT plots of the simulations can be displayed using LTT.plot, LTT.plot.gen and LTT.average.root. TreeSim further samples appropriately trees with n final tips from a set of trees generated by the common sampling algorithm stopping when a fixed number m>>n of leaves is first reached (sim.gsa.taxa). This latter method is appropriate for m-tip trees generated under a big class of models (details in the sim.gsa.taxa man page). For incomplete phylogeny, the missing speciation events can be added through simulations (corsim). (ii) sim.rateshifts.taxa is generalized to sim.bdsky.stt for serially sampled trees, where the trees are conditioned on either the number of sampled tips or the age. Furthermore, for a multitype-branching process with sequential sampling, trees on a fixed number of tips can be simulated using sim.bdtypes.stt.taxa.
}
\details{
\tabular{ll}{
Package: \tab TreeSim\cr
Type: \tab Package\cr
Version: \tab 1.9.1\cr
Date: \tab 2013-12-09\cr
License: \tab GPL-2  \cr
LazyLoad: \tab yes\cr
}
}
\author{
Tanja Stadler
%Maintainer: Tanja Stadler
 <http://www.tb.ethz.ch/people/tstadler>
}
\references{
Simulating trees on a fixed number of extant species. Syst. Biol. (2011) 60: 676-684.

K. Hartmann, D. Wong,  T. Stadler: Sampling trees from evolutionary models. Syst. Biol. (2010) 59: 465-476.

T. Stadler: On incomplete sampling under birth-death models and connections to the sampling-based coalescent.
J. Theo. Biol. (2009) 261: 58-66.

N. Cusimano, T. Stadler, S. Renner: A new method for handling missing species in diversification analysis applicable to randomly or non-randomly sampled phylogenies. Syst. Biol. (2012) 61:785-792.
}
%\keyword{tree, phylogeny, simulation}
\seealso{
\code{ape}
\code{geiger}
%\code{\link[ape]{ape}}
%\code{\link[geiger]{geiger}}
%\code{\link[<diversitree>:<diversitree>-package]{<diversitree>}}
}