\name{TreeSim-package}
\alias{TreeSim-package}
\alias{TreeSim}
\docType{package}
\title{
TreeSim: Simulating phylogenetic trees}
\description{
The package simulates phylogenetic trees under a constant-rate birth-death process, conditioned on having a fixed number of final tips, or a fixed age, or a fixed age and number of tips. When conditioning on the number of final tips, the method allows for shifts in rates and mass extinction events during the birth-death process. TreeSim further samples appropriately trees with n final tips from a set of trees generated by the common sampling algorithm stopping when a fixed number m>>n of leaves is first reached. This latter method is appropriate for m-tip trees generated under a big class of models (details in the bd.gsa.taxa man page).
}
\details{
\tabular{ll}{
Package: \tab TreeSim\cr
Type: \tab Package\cr
Version: \tab 1.3\cr
Date: \tab 2011-05-10\cr
License: \tab GPL-2  \cr
LazyLoad: \tab yes\cr
}
}
\author{
Tanja Stadler
%Maintainer: Tanja Stadler
 <http://www.tb.ethz.ch/people/tstadler>
}
\references{
Simulating trees on a fixed number of extant species. Syst. Biol. (2011).

K. Hartmann, D. Wong,  T. Stadler: Sampling trees from evolutionary models. Syst. Biol. (2010) 59: 465-476.

T. Stadler: On incomplete sampling under birth-death models and connections to the sampling-based coalescent.
J. Theo. Biol. (2009) 261: 58-66.
}
%\keyword{tree, phylogeny, simulation}
\seealso{
\code{ape}
\code{geiger}
%\code{\link[ape]{ape}}
%\code{\link[geiger]{geiger}}
%\code{\link[<diversitree>:<diversitree>-package]{<diversitree>}}
}