% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TreeBUGS-package.R
\docType{package}
\name{TreeBUGS-package}
\alias{TreeBUGS}
\alias{TreeBUGS-package}
\title{TreeBUGS: Hierarchical Multinomial Processing Tree Modeling}
\description{
{
\if{html}{\figure{TreeBUGS.png}{options: width=120 alt ="TreeBUGS" align="right" hspace="20"}}
\if{latex}{\figure{TreeBUGS.png}{options: width=0.5in}}

Uses standard MPT files in the .eqn-format (Moshagen, 2010) to fit hierarchical Bayesian MPT models.
Note that the software JAGS is required (\url{http://mcmc-jags.sourceforge.net}).
}

The core functions either fit a Beta-MPT model (\code{\link{betaMPT}}; Smith & Batchelder, 2010)
or a latent-trait MPT model (\code{\link{traitMPT}}; Klauer, 2010).
A fitted model can be inspected using convenient summary and plot functions tailored to hierarchical MPT models.

Detailed explanations and examples can be found in the package vignette, accessible via \code{vignette("TreeBUGS")}
}
\section{Citation}{


If you use TreeBUGS, please cite the software as follows:

Heck, D. W., Arnold, N. R., & Arnold, D. (2018).
TreeBUGS: An R package for hierarchical multinomial-processing-tree modeling.
\emph{Behavior Research Methods, 50}, 264–284.
}

\references{
Klauer, K. C. (2010). Hierarchical multinomial processing tree models: A latent-trait approach.
\emph{Psychometrika, 75}, 70-98.

Matzke, D., Dolan, C. V., Batchelder, W. H., & Wagenmakers, E.-J. (2015).
Bayesian estimation of multinomial processing tree models with heterogeneity in participants and items.
\emph{Psychometrika, 80}, 205-235.

Moshagen, M. (2010).
multiTree: A computer program for the analysis of multinomial processing tree models.
\emph{Behavior Research Methods, 42}, 42-54.

Smith, J. B., & Batchelder, W. H. (2008).
Assessing individual differences in categorical data.
\emph{Psychonomic Bulletin & Review, 15}, 713-731.

Smith, J. B., & Batchelder, W. H. (2010).
Beta-MPT: Multinomial processing tree models for addressing individual differences.
\emph{Journal of Mathematical Psychology, 54}, 167-183.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/danheck/TreeBUGS}
}

}
\author{
Daniel W. Heck, Denis Arnold, & Nina Arnold
}
