% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotConvergence.R
\name{plot.betaMPT}
\alias{plot.betaMPT}
\alias{plot.simpleMPT}
\alias{plot.traitMPT}
\title{Plot Convergence for Hierarchical MPT Models}
\usage{
\method{plot}{betaMPT}(x, parameter = "mean", type = "default", ...)

\method{plot}{simpleMPT}(x, type = "default", ...)

\method{plot}{traitMPT}(x, parameter = "mean", type = "default", ...)
}
\arguments{
\item{x}{fitted hierarchical MPT model (\code{\link{traitMPT}}, \code{\link{betaMPT}})}

\item{parameter}{which parameter to plot (e.g., \code{"theta"}, \code{"mean"}, \code{"rho"}, \code{"slope"}). Parameters are matched partially, in order to plot all entries of vector valued parameters (see \code{\link{getParam}} to get a list of parameters). Moreover, parameter labels can be used, e.g., \code{"theta[D]"} or \code{"rho[D,g]"}}

\item{type}{type of convergence plot. Can be one of \code{"default"} (trace+density), \code{"acf"} (auto-correlation function), \code{"trace"}, \code{"autocorr"}, \code{"crosscorr"},\code{"density"},   \code{"gelman"}. See, e.g., \code{\link[coda]{mcmc.list}}}

\item{...}{further arguments passed to the plotting functions in coda}
}
\description{
Plot Convergence for Hierarchical MPT Models
}
\section{Methods (by class)}{
\itemize{
\item \code{betaMPT}: Plot convergence for beta MPT

\item \code{simpleMPT}: Plot convergence for nonhierarchical MPT model

\item \code{traitMPT}: Plot convergence for latent-trait MPT
}}

