% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TreatmentSelection-package.R
\docType{package}
\name{TreatmentSelection-package}
\alias{TreatmentSelection-package}
\alias{TreatmentSelection}
\title{Evaluate markers used to guide patient treatment selection decisions}
\description{
A suite of descriptive and inferential methods designed to evaluate
one or more biomarkers for their ability to guide patient treatment 
recommendations.
}
\details{
\tabular{ll}{ Package: \tab TreatmentSelection\cr Type: \tab Package\cr
Version: \tab 2.0.-\cr Date: \tab 2016-07-28\cr License: \tab GPL-2\cr }
}
\examples{

# See individual function man pages for examples. 

?trtsel_measures
?trtsel
?plot.trtsel
?evaluate.trtsel
?compare.trtsel
?calibrate.trtsel

}
\references{
Janes H, Brown MD, Huang Y, et al. An approach to evaluating and comparing
biomarkers for patient treatment selection. 
**Int J Biostat.** 2014;10(1):99-121.
}
\seealso{
\code{\link{trtsel_measures}} for evaluating the performance of a user-specified marker-based treatment rule,
\code{\link{trtsel}} for creating trtsel objects,
\code{\link{plot.trtsel}} for plotting risk curves and more,
\code{\link{evaluate.trtsel}} for evaluating marker performance,
\code{\link{calibrate.trtsel}} for assessing model calibration, and
\code{\link{compare.trtsel}} to compare two trtsel object.
}
\author{
Marshall Brown and Holly Janes

Maintainer: Marshall Brown <mdbrown@fhcrc.org>
}
\keyword{package}
