% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SpeedFilter.R
\docType{methods}
\name{speedFilter}
\alias{speedFilter}
\alias{speedFilter,Track,numeric-method}
\title{Speed filter}
\usage{
speedFilter(A1, speed)

\S4method{speedFilter}{Track,numeric}(A1, speed)
}
\arguments{
\item{A1}{Represents a single trajectory followed by a person, animal or object}

\item{speed}{Is the maximum speed parameter}
}
\description{
A speed filter that filters out trajectory observations whose speeds are above a user-defined maximum velocity
}
\examples{
library(ggplot2)

speed <- min(A1@connections$speed)

sf <- speedFilter(A1,speed)

df <- data.frame(x=sf@sp@coords[,1],y=sf@sp@coords[,2])

ggplot(df,aes(x=df$x,y=df$y))+geom_path(aes(group = 1), arrow = arrow(),color='blue')

}
\author{
Diego Monteiro
}
