% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/downloadTSet.R
\name{downloadTSet}
\alias{downloadTSet}
\title{Download a ToxicoSet object}
\usage{
downloadTSet(name, saveDir = tempdir(), tSetFileName = NULL, verbose = TRUE)
}
\arguments{
\item{name}{\code{Character} string, the name of the PhamracoSet to download.}

\item{saveDir}{\code{Character} string with the folder path where the
ToxicoSet should be saved. Defaults to \code{'./tSets/'}. Will create
directory if it does not exist.}

\item{tSetFileName}{\code{character} string, the file name to save the dataset under}

\item{verbose}{\code{bool} Should status messages be printed during download.
Defaults to TRUE.}
}
\value{
A tSet object with the dataset, downloaded from our server
}
\description{
This function allows you to download a \code{ToxicoSet} object for use with this
package. The \code{ToxicoSets} have been extensively curated and organised within
a PharacoSet class, enabling use with all the analysis tools provided in
\code{PharmacoGx}.
}
\examples{
if (interactive()){
downloadtSet("TGGATESvignette")
}

}
