% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rankGeneDrugPerturbation.R
\name{rankGeneDrugPerturbation}
\alias{rankGeneDrugPerturbation}
\title{Rank genes based on drug effect}
\usage{
rankGeneDrugPerturbation(data, drug, drug.id, drug.concentration, type, xp,
  batch, duration, single.type = FALSE, nthread = 1, verbose = FALSE)
}
\arguments{
\item{data:}{gene expression data matrix}

\item{drug:}{single or vector of drug(s) of interest; if a vector of drugs is provided, they will be considered as being the same drug and will be jointly analyszed}

\item{drug.id:}{drug used in each experiment}

\item{drug.concentration:}{drug concentration used in each experiment}

\item{type:}{cell or tissue type for each experiment}

\item{xp:}{type of experiment (perturbation or control)}

\item{batch:}{experiment batches}

\item{duration:}{The duration of the experiment, in a consistent unit}

\item{single.type:}{Should the statitsics be computed for each cell/tissue type separately?}

\item{nthread:}{number of parallel threads (bound to the maximum number of cores available)}
}
\value{
[list] of \code{data.frame}s with the statistics for each gene, for each type
}
\description{
A helper function called from within `drugPerturbationSig`. This is intended
  for developer use only; if you aren't debugging the package, this should
  not be used.
}
\keyword{internal}
