% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/keep_top_n.R
\name{keep_top_n}
\alias{keep_top_n}
\title{Keep rows from top groups of a column}
\usage{
keep_top_n(.data, col, n = 10)
}
\arguments{
\item{.data}{The data frame to operate on}

\item{col}{A formula indicating the column to group over}

\item{n}{The number of top groups to extract}
}
\value{
A data frame conaining only rows belonging to the top n groups of the column
}
\description{
Extract rows belonging to top n groups of a certain column
}
\examples{
\dontrun{
# All the cars
(nrow(mtcars))
# Only those in the top 2 groups based on the # carbs
nrow(keep_top_n(mtcars, ~carb, n=2))
}
}
\author{
Jeroen Janssens
}
