% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00-utils.R
\name{find_columns_by_pattern}
\alias{find_columns_by_pattern}
\title{Find columns by pattern}
\usage{
find_columns_by_pattern(data, pattern = "weighted_", sort = TRUE)
}
\arguments{
\item{data}{Data frame to search.}

\item{pattern}{Regular expression pattern to match.}

\item{sort}{Logical. Sort results numerically.}
}
\value{
Character vector of matching column names.
}
\description{
Identifies columns in a data frame that match a specific pattern.
Useful for finding length columns, weight columns, etc.
}
\examples{
# Create dummy data
data <- data.frame(
  weighted_8.5 = c(1, 2, 3),
  weighted_10 = c(4, 5, 6),
  `8` = c(7, 8, 9),
  other = c(10, 11, 12)
)

# Find weighted columns
weighted_cols <- find_columns_by_pattern(data, pattern = "weighted_")

# Find numeric-only named columns (e.g., "8")
length_cols <- find_columns_by_pattern(data, pattern = "")

}
