% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tv_sentiment_index_all_coefs.R
\name{tv_sentiment_index_all_coefs}
\alias{tv_sentiment_index_all_coefs}
\title{TV sentiment index using all positive and negative coefficients.}
\usage{
tv_sentiment_index_all_coefs(x, w, y, alpha, lambda, newx, family, scaled,
  k_mov_avg, type_mov_avg)
}
\arguments{
\item{x}{A matrix of variables to be selected by shrinkrage methods.}

\item{w}{Optional Argument. A matrix of variables to be selected by shrinkrage methods.}

\item{y}{the response variable.}

\item{alpha}{the alpha required in glmnet.}

\item{lambda}{the lambda required in glmnet.}

\item{newx}{Matrix  that selection will be applied. Useful for time series, when we need the observation at time t.}

\item{family}{the glmnet family.}

\item{scaled}{Set TRUE for scale and FALSE for no scale.}

\item{k_mov_avg}{The moving average order.}

\item{type_mov_avg}{The type of moving average. See \link[pracma]{movavg}.}
}
\value{
A list with the net, postive and negative sentiment index. The net time-varying sentiment index. The index is based on the word/term counting and is computed using: tv_index=(pos-neg)/(pos+neg). The postive sentiment index is computed using: tv_index_pos=pos/(pos+neg) and the negative tv_index_neg=neg/(pos+neg).
}
\description{
TV sentiment index using all positive and negative coefficients.
}
\examples{
suppressWarnings(RNGversion("3.5.0"))
set.seed(1)
data("stock_data")
data("news_data")
y=as.matrix(stock_data[,2])
w=as.matrix(stock_data[,3])
data("news_data")
X=news_data[,2:ncol(news_data)]
x=as.matrix(X)
grid_alphas=0.05
cont_folds=TRUE
t=length(y)
optimal_alphas=optimal_alphas(x=x[1:(t-1),],
                              y=y[2:t],grid_alphas=grid_alphas,cont_folds=TRUE,family="gaussian")
tv_idx=tv_sentiment_index_all_coefs(x=x[1:(t-1),],y=y[2:t],alpha = optimal_alphas[1],
                                 lambda = optimal_alphas[2],newx=x,
                                 scaled = TRUE,k_mov_avg = 4,type_mov_avg = "s")
}
