% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loading_functions.R
\name{loadConstraints}
\alias{loadConstraints}
\title{Load constraints}
\usage{
loadConstraints(object, pool, item_attrib, st_attrib = NULL)
}
\arguments{
\item{object}{constraint specifications. Can be a \code{\link{data.frame}} or the file path of a .csv file. See the vignette for a description of the expected format.}

\item{pool}{an \code{\linkS4class{item_pool}} object. Use \code{\link{loadItemPool}} for this.}

\item{item_attrib}{an \code{\linkS4class{item_attrib}} object. Use \code{\link{loadItemAttrib}} for this.}

\item{st_attrib}{(optional) an \code{\linkS4class{st_attrib}} object. Use \code{\link{loadStAttrib}} for this.}
}
\value{
\code{\link{loadConstraints}} returns a \code{\linkS4class{constraints}} object. This object is used in \code{\link{Static}} and \code{\link{Shadow}}.
}
\description{
\code{\link{loadConstraints}} is a data loading function for creating a \code{\linkS4class{constraints}} object.
\code{\link{loadConstraints}} can read constraints from a data.frame or a .csv file.
The contents must be in the expected format; see the vignette in \code{vignette("constraints")} for a documentation.
}
\examples{
## Read from data.frame:
itempool_science    <- loadItemPool(itempool_science_data)
itemattrib_science  <- loadItemAttrib(itemattrib_science_data, itempool_science)
constraints_science <- loadConstraints(constraints_science_data,
  itempool_science, itemattrib_science)

## Read from file: write to tempdir() for illustration and clean afterwards
f <- file.path(tempdir(), "constraints_science.csv")
write.csv(constraints_science_data, f, row.names = FALSE)
constraints_science <- loadConstraints(f,
  itempool_science, itemattrib_science)
file.remove(f)

}
\seealso{
\code{\link{dataset_science}}, \code{\link{dataset_reading}}, \code{\link{dataset_fatigue}}, \code{\link{dataset_bayes}} for examples.
}
