% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/item_functions.R
\docType{methods}
\name{calcJacobian}
\alias{calcJacobian}
\alias{calcJacobian,item_1PL,numeric,numeric-method}
\alias{calcJacobian,item_1PL,numeric-method}
\alias{calcJacobian,item_2PL,numeric,numeric-method}
\alias{calcJacobian,item_2PL,numeric-method}
\alias{calcJacobian,item_3PL,numeric,numeric-method}
\alias{calcJacobian,item_3PL,numeric-method}
\alias{calcJacobian,item_PC,numeric,numeric-method}
\alias{calcJacobian,item_PC,numeric-method}
\alias{calcJacobian,item_GPC,numeric,numeric-method}
\alias{calcJacobian,item_GPC,numeric-method}
\alias{calcJacobian,item_GR,numeric,numeric-method}
\alias{calcJacobian,item_GR,numeric-method}
\alias{calcJacobian,item_pool,numeric,numeric-method}
\alias{calcJacobian,item_pool,numeric-method}
\alias{calcJacobian,item_pool_cluster,numeric,list-method}
\alias{calcJacobian,item_pool_cluster,numeric-method}
\title{Calculate first derivative of log-likelihood}
\usage{
calcJacobian(object, theta, resp)

\S4method{calcJacobian}{item_1PL,numeric,numeric}(object, theta, resp)

\S4method{calcJacobian}{item_2PL,numeric,numeric}(object, theta, resp)

\S4method{calcJacobian}{item_3PL,numeric,numeric}(object, theta, resp)

\S4method{calcJacobian}{item_PC,numeric,numeric}(object, theta, resp)

\S4method{calcJacobian}{item_GPC,numeric,numeric}(object, theta, resp)

\S4method{calcJacobian}{item_GR,numeric,numeric}(object, theta, resp)

\S4method{calcJacobian}{item_pool,numeric,numeric}(object, theta, resp)

\S4method{calcJacobian}{item_pool_cluster,numeric,list}(object, theta, resp)
}
\arguments{
\item{object}{an \code{\link{item}} or an \code{\linkS4class{item_pool}} object.}

\item{theta}{theta values to use.}

\item{resp}{the response data to use.}
}
\value{
\describe{
  \item{\code{\link{item}} object:}{\code{\link{calcJacobian}} returns a length \emph{nq} vector containing the first derivative of the log-likelihood function, of observing the response at each theta.}
  \item{\code{\linkS4class{item_pool}} object:}{\code{\link{calcJacobian}} returns a (\emph{nq}, \emph{ni}) matrix containing the first derivative of the log-likelihood function, of observing the response at each theta.}
}
\describe{
  \item{\emph{notations}}{\itemize{
    \item{\emph{nq} denotes the number of theta values.}
    \item{\emph{ni} denotes the number of items in the \code{\linkS4class{item_pool}} object.}
  }}
}
}
\description{
\code{\link{calcJacobian}} is a function to calculate the first derivative of the log-likelihood function.
}
\examples{
item_1    <- new("item_1PL", difficulty = 0.5)
item_2    <- new("item_2PL", slope = 1.0, difficulty = 0.5)
item_3    <- new("item_3PL", slope = 1.0, difficulty = 0.5, guessing = 0.2)
item_4    <- new("item_PC", threshold = c(-1, 0, 1), ncat = 4)
item_5    <- new("item_GPC", slope = 1.2, threshold = c(-0.8, -1.0, 0.5), ncat = 4)
item_6    <- new("item_GR", slope = 0.9, category = c(-1, 0, 1), ncat = 4)

j_item_1 <- calcJacobian(item_1, seq(-3, 3, 1), 0)
j_item_2 <- calcJacobian(item_2, seq(-3, 3, 1), 0)
j_item_3 <- calcJacobian(item_3, seq(-3, 3, 1), 0)
j_item_4 <- calcJacobian(item_4, seq(-3, 3, 1), 0)
j_item_5 <- calcJacobian(item_5, seq(-3, 3, 1), 0)
j_item_6 <- calcJacobian(item_6, seq(-3, 3, 1), 0)
j_pool   <- calcJacobian(
  itempool_science, seq(-3, 3, 1),
  rep(0, itempool_science@ni)
)

}
\references{
Rasch, G. (1960). \emph{Probabilistic models for some intelligence and attainment tests.}
Copenhagen: Danish Institute for Educational Research.

Lord, F. M. (1952). A theory of test scores (Psychometric Monograph No. 7). Richmond, VA: Psychometric Corporation.

Birnbaum, A. (1957). \emph{Efficient design and use of tests of mental ability for various decision-making problems}
(Series Report No. 58-16. Project No. 7755-23).
Randolph Air Force Base, TX: USAF School of Aviation Medicine.

Birnbaum, A. (1958). \emph{On the estimation of mental ability}
(Series Report No. 15. Project No. 7755-23).
Randolph Air Force Base, TX: USAF School of Aviation Medicine.

Birnbaum, A. (1958). \emph{Further considerations of efficiency in tests of a mental ability}
(Series Report No. 17. Project No. 7755-23).
Randolph Air Force Base, TX: USAF School of Aviation Medicine.

Birnbaum, A. (1968). Some latent trait models and their use in inferring an examinee's ability.
In Lord, F. M., Novick, M. R. (eds.), \emph{Statistical Theories of Mental Test Scores}, 397-479.
Reading, MA: Addison-Wesley.

Masters, G. N. (1982). A Rasch model for partial credit scoring.
\emph{Psychometrika, 47}(2), 149-174.

Andrich, D. (1978). A rating formulation for ordered response categories.
\emph{Psychometrika, 43}(4), 561-573.

Muraki, E. (1992). A generalized partial credit model: Application of an EM algorithm.
\emph{Applied Psychological Measurement, 16}(2), 159-176.

Samejima, F. (1969). Estimation of latent ability using a response pattern of graded scores.
\emph{Psychometrika Monograph, 17}.
}
