% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shadow_functions.R
\name{plotInfo}
\alias{plotInfo}
\title{Draw item information plots}
\usage{
plotInfo(object, theta = seq(-3, 3, 0.1), info_type = "FISHER",
  select = NULL, file_pdf = NULL, color = "blue", width = 7,
  height = 6, mfrow = c(2, 4))
}
\arguments{
\item{object}{An \code{\linkS4class{item_pool}} object.}

\item{theta}{A theta grid. Default is \code{seq(-3, 3, .1)}.}

\item{info_type}{Type of information.}

\item{select}{A vector of indices identifying the items to subset.}

\item{file_pdf}{If supplied a filename, save as a PDF file.}

\item{color}{Plotting color.}

\item{width}{Width of graphics device.}

\item{height}{Width of graphics device.}

\item{mfrow}{Number of multiple figures defined as c(nrow, ncol).}
}
\description{
Draw item information plots.
}
\examples{
subitempool <- subsetItemPool(itempool_science, 1:8)
plotInfo(subitempool)

}
