% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Contours.R
\name{TernaryContour}
\alias{TernaryContour}
\title{Add contours to a ternary plot}
\usage{
TernaryContour(
  Func,
  resolution = 96L,
  direction = getOption("ternDirection", 1L),
  region = getOption("ternRegion", ternRegionDefault),
  within = NULL,
  filled = FALSE,
  legend,
  legend... = list(),
  nlevels = 10,
  levels = pretty(zlim, nlevels),
  zlim,
  color.palette = function(n) hcl.colors(n, palette = "viridis", alpha = 0.6),
  fill.col = color.palette(length(levels) - 1),
  func... = list(),
  ...
)
}
\arguments{
\item{Func}{Function taking vectors of coordinates \code{a}, \code{b} and \code{c}, which
returns a numeric vector whose value at each coordinate will be depicted.}

\item{resolution}{The number of triangles whose base should lie on the longest
axis of the triangle.  Higher numbers will result in smaller subdivisions and smoother
colour gradients, but at a computational cost.}

\item{direction}{(optional) Integer specifying the direction that the
current ternary plot should point: 1, up; 2, right; 3, down; 4, left.}

\item{region}{(optional) Named list of length two specifying the the
\code{min}imum and \code{max}imum values of each ternary axis to be drawn
(e.g. \verb{list(min = c(40, 0, 0), max = c(100, 60, 60)});
or a set of coordinates in a format accepted by \code{\link[=TernaryPoints]{TernaryPoints()}}.
The plotted region will correspond to the smallest equilateral triangle
that encompasses the specified ranges or coordinates.}

\item{within}{List or matrix of \emph{x, y} coordinates within which contours
should be evaluated, in any format supported by
\code{\link[grDevices:xy.coords]{xy.coords(x = within)}}.
If \code{NULL}, defaults to a region slightly smaller than the ternary plot.
The \verb{$hull} entry generated by \code{TriangleInHull()} may also be used.}

\item{filled}{Logical; if \code{TRUE}, contours will be filled
(using \code{\link[graphics]{.filled.contour}()}.).}

\item{legend}{Character vector specifying annotations for colour scale.
If not provided, no colour legend is displayed.
Specify \code{TRUE} to generate automatically, or a single integer to generate
\code{legend} annotations.}

\item{legend...}{List of additional parameters to send to
\code{\link[PlotTools:SpectrumLegend]{SpectrumLegend()}}.}

\item{nlevels, levels, zlim, \dots}{parameters to pass to
\code{\link[graphics]{contour}()}.}

\item{color.palette}{parameters to pass to
\code{\link[graphics]{.filled.contour}()}.}

\item{fill.col}{Sent as \code{col} parameter to
\code{\link[graphics]{.filled.contour}()}.
Computed from \code{color.palette} if not specified.}

\item{func...}{List of additional parameters to send to \code{Func()}.}
}
\value{
\code{TernaryContour()}  invisibly returns a list containing:
\itemize{
\item \code{x},\code{y}: the Cartesian coordinates of each evaluated point;
\item \code{z}: The value of \code{Func()} at each coordinate.
}
}
\description{
Draws contour lines to depict the value of a function in ternary space.
}
\examples{
FunctionToContour <- function (a, b, c) {
  a - c + (4 * a * b) + (27 * a * b * c)
}

# Set up plot
originalPar <- par(mar = rep(0, 4))
TernaryPlot(alab = "a", blab = "b", clab = "c")
values <- TernaryPointValues(FunctionToContour, resolution = 24L)
ColourTernary(
  values,
  legend = signif(seq(max(values), min(values), length.out = 4), 2),
  bty = "n"
)
TernaryContour(FunctionToContour, resolution = 36L)

# Note that FunctionToContour is sent a vector.
# Instead of
BadMax <- function (a, b, c) {
  max(a, b, c)
}

# Use
GoodMax <- function (a, b, c) {
  pmax(a, b, c)
}
TernaryPlot(alab = "a", blab = "b", clab = "c")
ColourTernary(TernaryPointValues(GoodMax))
TernaryContour(GoodMax)

# Or, for a generalizable example,
GeneralMax <- function (a, b, c) {
  apply(rbind(a, b, c), 2, max)
}
TernaryPlot(alab = "a", blab = "b", clab = "c")
# Fill the contour areas, rather than using tiles
TernaryContour(GeneralMax, filled = TRUE,
               legend = c("Max", "...", "Min"), legend... = list(bty = "n"),
               fill.col =  hcl.colors(14, palette = "viridis", alpha = 0.6))
# Re-draw edges of plot triangle over fill
TernaryPolygon(diag(3))

# Restore plotting parameters
par(originalPar)
}
\seealso{
Other contour plotting functions: 
\code{\link{ColourTernary}()},
\code{\link{TernaryDensityContour}()},
\code{\link{TernaryPointValues}()}
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{contour plotting functions}
