% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TernaryPlot.R
\name{AddToTernary}
\alias{AddToTernary}
\alias{TernaryPoints}
\alias{TernaryText}
\alias{TernaryLines}
\alias{TernaryPolygon}
\title{Add to Ternary Plot}
\usage{
AddToTernary(PlottingFunction, coordinates, ...)

TernaryPoints(coordinates, ...)

TernaryText(coordinates, ...)

TernaryLines(coordinates, ...)

TernaryPolygon(coordinates, ...)
}
\arguments{
\item{PlottingFunction}{Function to add data to a plot; perhaps one of
\code{\link[graphics]{points}},
\code{\link[graphics]{lines}} or
\code{\link[graphics]{text}}.}

\item{coordinates}{A list, matrix, data.frame or vector in which each
element (or row) specifies
the three coordinates of a point in ternary space.}

\item{\dots}{Additional parameters to pass to \code{PlottingFunction}.}
}
\description{
Plot points onto a ternary diagram created with \code{\link{TernaryPlot}}.
}
\section{Functions}{
\itemize{
\item \code{TernaryPoints}: Add points

\item \code{TernaryText}: Add points

\item \code{TernaryLines}: Add points

\item \code{TernaryPolygon}: Add points
}}

\examples{
{
  coords <- list(
    A = c(1, 0, 2),
    B = c(1, 1, 1),
    C = c(1.5, 1.5, 0),
    D = c(0.5, 1.5, 1)
  )
  TernaryPlot()
  AddToTernary(lines, coords, col='green', lwd=2)
  TernaryLines(coords, col='red', lty='dotted')
  TernaryText(coords, cex=0.7, col='red')
  TernaryPoints(coords, pch=1, cex=2, col='blue')
  AddToTernary(points, coords, pch=1, cex=3)
}

}
\author{
Martin R. Smith
}
