% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CdN_DHxHt.f.R
\name{CdN_DHxHt.f}
\alias{CdN_DHxHt.f}
\title{percentile for estimated taper curve diameter}
\usage{
CdN_DHxHt.f(Ht, Hx, qD, Hm, Dm, par.lme, Rfn, ...)
}
\arguments{
\item{Ht}{tree height}

\item{Hx}{Numeric vector of stem heights (m) along which to return the expected diameter.}

\item{qD}{vector of quantiles, passed to \code{pnorm}}

\item{Hm}{measured height of respective diameters \code{Dm}}

\item{Dm}{measured diameter}

\item{par.lme}{List of taper model parameters obtained by \code{\link{TapeR_FIT_LME.f}}.}

\item{Rfn}{list with function name to provide estimated or assumed residual 
variances for the given measurements, optionally parameters for such functions}

\item{...}{not currently used}
}
\value{
percentile for estimated taper curve diameter at position \code{Hx}
given \code{Ht}, \code{Hm} and \code{Dm}
}
\description{
Internal function not usually called by users
}
\author{
Edgar Kublin
}
