% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.Tenv.R
\name{plot.Tenv}
\alias{plot.Tenv}
\title{Plot coefficients and p-value for Tenv object.}
\usage{
\method{plot}{Tenv}(
  x,
  level = 0.05,
  main = paste0("Coefficient plot ", "(", x$method, ")"),
  main_p = paste0("P value plot ", "(", x$method, ")"),
  xlab = "",
  ylab = "",
  axes = TRUE,
  ask = TRUE,
  ...
)
}
\arguments{
\item{x}{An object of class \code{"Tenv"}, as the ones returned from \code{TPR.fit} or \code{TRR.fit}.}

\item{level}{The significant level of p-value. Default is 0.05.}

\item{main}{The title of coefficient plot.}

\item{main_p}{The title of \eqn{p}-value plot.}

\item{xlab}{The title of x-axis.}

\item{ylab}{The title of y-axis.}

\item{axes}{A logical value specifying whether the axes should be drawn.}

\item{ask}{A logical value. If it is TRUE (default), user is prompted before the second plot is shown (if exists).}

\item{...}{Other parameters to be passed to the plotting functions.}
}
\description{
Plot method for object returned from \code{TRR.fit} and \code{TPR.fit} functions.
}
\details{
\code{coef(x)} must be a two-way tensor or a matrix.

Since \eqn{p}-value depend on \eqn{\widehat{\mathrm{cov}}^{-1}\{\mathrm{vec}(\mathbf{X})\}} which is unavailable for the ultra-high dimensional \eqn{\mathrm{vec}(\mathbf{X})} in tensor predictor regression (TPR), the \eqn{p}-value plot is not provided for the object returned from \code{TPR.fit}.
Therefore, for the object return from \code{TPR.fit}, only the coefficients plot is displayed. And for the object return from \code{TRR.fit}, both the coefficients plot and \eqn{p}-value plot are displayed.

\code{main} and \code{main_p} control the titles of coefficient plot and \eqn{p}-value plot separately. Some other arguments used in function \code{graphics::image}, e.g., \code{xlim, ylim, zlim, col, xaxs, yaxs, etc.,} can be passed to \code{...}

\code{ask} can be set as \code{FALSE} if the pause before the second plot is not preferred. If \code{x} is an object from \code{TPR.fit}, no pause is enabled.
}
\examples{
 data("bat")
 x <- bat$x
 y <- bat$y
 fit <- TRR.fit(x, y, method="standard")
 plot(fit)

 ## Change the significant level to 0.1
 plot(fit, level = 0.1)
}
\seealso{
\code{\link{TRR.fit}, \link{TPR.fit}}
}
