% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TPR_sim.R
\name{TPR_sim}
\alias{TPR_sim}
\title{Generate simulation data for TPR}
\usage{
TPR_sim(p, r, u, n)
}
\arguments{
\item{p}{The dimension of predictor, a vector in the form of \eqn{(p_1,\cdots, p_m)}.}

\item{r}{The dimension of response, a scale.}

\item{u}{The structural dimension of envelopes at each mode, a vector with the same length as p.}

\item{n}{The sample size.}
}
\value{
\describe{
\item{Xn}{The predictor of dimension \eqn{p_1\times \cdots\times p_m \times n}}
\item{Yn}{The response of dimension \eqn{r\times n}}
\item{Gamma}{The envelope subspace basis of dimension \eqn{p_k \times u_k, \ k=1,\ldots,m}}
\item{Bhat}{The coefficient tensor of dimension \eqn{p_1\times \cdots\times p_m \times r}}
\item{Sigma}{The covariance matrix of X}
\item{p, r, u}{The input \code{p,r,u}}
}
}
\description{
This function is used to generate simulation data used in Tensor Prediction Regression.
}
\details{
The tensor predictor regression model is of the form,
\deqn{\mathbf{Y} = \mathbf{B}_{(m+1)}\mathrm{vec}(\mathbf{X}) +\boldsymbol{\varepsilon}}
where response \eqn{\mathbf{Y} \in R^{r}}, predictor \eqn{\mathbf{X} \in R^{p_1\times \cdots\times p_m}}, and
the error term is multivariate normal distributed. The predictor is tensor normal distributed,
\deqn{\mathbf{X}\sim TN(0;\boldsymbol{\Sigma}_1,\dots,\boldsymbol{\Sigma}_m)}
According to the tensor envelope structure, we have
\deqn{\mathbf{B} = [\Theta;\boldsymbol{\Gamma}_1,\ldots,\boldsymbol{\Gamma}_m,\mathbf{I}_p], \quad \mbox{for some } \boldsymbol{\Theta} \in R^{u_1\times\cdots\times u_m \times p}}
\deqn{\boldsymbol{\Sigma}_k = \boldsymbol{\Gamma}_k\boldsymbol{\Omega}_k\boldsymbol{\Gamma}_k^{T}+\boldsymbol{\Gamma}_{0k}\boldsymbol{\Omega}_{0k}\boldsymbol{\Gamma}_{0k}^\top,
\quad \mbox{for some } \boldsymbol{\Omega}_k, \boldsymbol{\Omega}_{0k},\ k=1,\ldots,m.}
}
\note{
The length of p must match the length of u, and each element of u must be less than the corresponding element in p.
}
\examples{
p <- c(10, 10, 10)
u <- c(1, 1, 1)
r <- 5
n <- 200
dat <- TPR_sim(p = p, r = r, u = u, n = n)
Xn <- dat$Xn
Yn <- dat$Yn

}
\references{
Zhang, X., Li, L. (2017). Tensor Envelope Partial Least-Squares Regression. Technometrics, 59(4), 426-436.
}
\seealso{
\code{\link{TRR_sim}}.
}
