% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SAPC.R
\name{SAPC_TFM}
\alias{SAPC_TFM}
\title{Stochastic Approximation Principal Component Analysis}
\usage{
SAPC_TFM(x, m, A, D, p)
}
\arguments{
\item{x}{The data used in the SAPC analysis.}

\item{m}{The number of common factors.}

\item{A}{The true factor loadings matrix.}

\item{D}{The true uniquenesses matrix.}

\item{p}{The number of variables.}
}
\value{
A list of metrics including:
\item{Asa}{Estimated factor loadings matrix obtained from the SAPC analysis.}
\item{Dsa}{Estimated uniquenesses vector obtained from the SAPC analysis.}
\item{MSESigmaA}{Mean squared error of the estimated factor loadings (Asa) compared to the true loadings (A).}
\item{MSESigmaD}{Mean squared error of the estimated uniquenesses (Dsa) compared to the true uniquenesses (D).}
\item{LSigmaA}{Loss metric for the estimated factor loadings (Asa), indicating the relative error compared to the true loadings (A).}
\item{LSigmaD}{Loss metric for the estimated uniquenesses (Dsa), indicating the relative error compared to the true uniquenesses (D).}
}
\description{
This function calculates several metrics for the SAPC method,
including the estimated factor loadings and uniquenesses, and various
error metrics comparing the estimated matrices with the true matrices.
}
\examples{
\dontrun{
library(MASS)
library(relliptical)
library(SOPC)
SAPC_MSESigmaA <- c()
SAPC_MSESigmaD <- c()
SAPC_LSigmaA <- c()
SAPC_LSigmaD <- c()
result <- SAPC_TFM(data, m = m, A = A, D = D, p = p)
print(result)}
}
