% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summaries_dist2.R
\name{fsdist2}
\alias{fsdist2}
\title{Pairwise \eqn{L_p} Distance for Two Sets of Functional Summaries}
\usage{
fsdist2(fslist1, fslist2, p = 2)
}
\arguments{
\item{fslist1}{a length-\eqn{M} list of functional summaries of persistent diagrams.}

\item{fslist2}{a length-\eqn{N} list of functional summaries of persistent diagrams.}

\item{p}{an exponent in \eqn{[1,\infty)} (default: 2).}
}
\value{
an \eqn{(M\times N)} distance matrix.
}
\description{
Given two sets of functional summaries \eqn{\Lambda_1 (t), \ldots, \Lambda_M (t)} and 
\eqn{\Omega_1 (t), \ldots, \Omega_N (t)}, compute \eqn{L_p} distance across pairs.
}
\examples{
\donttest{
# ---------------------------------------------------------------------------
#         Compute L1 and L2 Distance for Two Sets of Landscapes
#
# First  set consists of {Class 1, Class 2}, while
# Second set consists of {Class 1, Class 3} where
#
# - Class 1 : 'iris' dataset with noise
# - Class 2 : samples from 'gen2holes()'
# - Class 3 : samples from 'gen2circles()'
# ---------------------------------------------------------------------------
## Generate Data and Diagram from VR Filtration
ndata      = 10
list_rips1 = list()
list_rips2 = list()
for (i in 1:ndata){
  dat1 = as.matrix(iris[,1:4]) + matrix(rnorm(150*4, sd=4), ncol=4)
  dat2 = gen2holes(n=100, sd=1)$data
  dat3 = as.matrix(iris[,1:4]) + matrix(rnorm(150*4, sd=4), ncol=4)
  dat4 = gen2circles(n=100, sd=1)$data
  
  list_rips1[[i]]       = diagRips(dat1, maxdim=1)
  list_rips1[[i+ndata]] = diagRips(dat2, maxdim=1)
  
  list_rips2[[i]]       = diagRips(dat3, maxdim=1)
  list_rips2[[i+ndata]] = diagRips(dat4, maxdim=1)
}

## Compute Persistence Landscapes from Each Diagram with k=10 Functions
#  We try to get distance in dimension 1 only for faster comparison.
list_pset1 = list()
list_pset2 = list()
for (i in 1:(2*ndata)){
  list_pset1[[i]] = diag2landscape(list_rips1[[i]], dimension=1, k=10)
  list_pset2[[i]] = diag2landscape(list_rips2[[i]], dimension=1, k=10)
}

## Compute L1 and L2 Distance Matrix
dmat1 = fsdist2(list_pset1, list_pset2, p=1)
dmat2 = fsdist2(list_pset1, list_pset2, p=2)

## Visualize
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,2), pty="s")
image(dmat1[,(2*ndata):1], axes=FALSE, main="distance for p=1")
image(dmat2[,(2*ndata):1], axes=FALSE, main="distance for p=2")
par(opar)
}

}
\concept{summaries}
