% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmri_pval_comparison_3d.R
\name{fmri_pval_comparison_3d}
\alias{fmri_pval_comparison_3d}
\title{comparison between 3d visualization for p-values}
\usage{
fmri_pval_comparison_3d(
  pval_3d_ls,
  mask,
  p_threshold,
  method_ls,
  color_pal_ls = list("YlOrRd", "YlGnBu"),
  multi_pranges = TRUE
)
}
\arguments{
\item{pval_3d_ls}{a list of two element, each element is a 3D array of p-values used to plot activated area of the brain}

\item{mask}{a 3D nifti or 3D array of data to show the shell of the brain}

\item{p_threshold}{NULL or a numeric value that can be selected randomly below 0.05 to 
drop insignificant p-values of no need or drop no p-values. If 'low5_percent' method is used, 
make 'p_threshold' as NULL. The default is 0.05.}

\item{method_ls}{a string that represents method for the plot. 
There are 2 options: 'scale_p' and 'low5_percent'. The default is 'scale_p'. 
'scale_p' is to draw the plot with fixed color scale for fixed range of p value; 
'low5_percent' is to draw the plot for the smallest 5 percent of p value 
when all the p values are not significant}

\item{color_pal_ls}{a list of two element. Each element is the name of 
the color palettes provided by \code{RColorBrewer}. The default is list('YlOrRd', 'YlGnBu').}

\item{multi_pranges}{an option under 'scale_p' method to decide whether there are at most 9 colors 
in the legend for the ranges of p value, or at most 4 colors. 
The default is TRUE, choosing the larger number of colors for the plot.}
}
\value{
a plot drawn by \code{plotly}
}
\description{
a visualization method, use \code{plotly} to compare 
the activated parts inside the brain, using two sets of color palettes. 
The activated parts are localized with different p values.
}
\details{
The function \code{fmri_pval_comparison_3d} is used to visualize and compare the 3D plots of 
the activated parts in one brain shell. The activated parts are plotted 
based on p-values provided. Note that this comparison can only be made when the masks 
of the two p values are the same. When providing input of two set of the 3D array of p-values, 
corresponding p threshold for each p value data, and the method to draw the plot, 
the plot will be generated with one brain shell and two groups of activated parts 
in two sets of color palettes. The size and color of the scatter points represent 
different stimulated levels of the activated parts.
}
\examples{
# sample 3D data of mask provided by the package
dim(mask)
# sample 3D p value provided by the package
dim(phase2_pval)
dim(phase3_pval)

fmri_pval_comparison_3d(list(phase2_pval, phase3_pval), mask, 
                        list(0.05, 0.05), list('scale_p', 'scale_p'), multi_pranges=FALSE)
}
\author{
SOCR team <\url{http://socr.umich.edu/people/}>
}
