% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataComp.R
\name{dataComp}
\alias{dataComp}
\title{Checking for equality in the features of two data sets.}
\usage{
dataComp(obs_data, new_data)
}
\arguments{
\item{obs_data}{The original data set to which the next will be compared, of the type "data.frame".}

\item{new_data}{The fully or partially synthetic data set to be compared to the observed data, of the type "data.frame".}
}
\value{
A list containing the following components:

\item{same.dim}{A logical value indicating whether or not \code{obs_data} and \code{new_data} have the same dimensions.}

\item{same.order}{A logical value indicating whether or not the variables in \code{obs_data} and \code{new_data} are in the same order.}

\item{class.identical}{A logical value indicating where or not the variable classifications are identical.}

\item{class.table}{A table of types of variable classifications.}

\item{fac.num.same}{A logical value indicating whether or not the factors in the data sets have the same number of levels.}

\item{fac.lev.same}{A logical value indicating whether or not the factors in the data sets have the same levels.}
}
\description{
This function will check for comparability between two data sets, including dimensions, order of variables, variable classifications, and levels of factors.
When a data set is fully or partially synthesized from an observed data set, these are the features that should be equal between the data sets so the utility of the synthetic data can be measured.
}
\details{
This function was developed with the intention of making the job of researching synthetic data utility a bit easier by making preliminary data set comparisons quickly.
}
\examples{
#PPA is observed data set, PPAps1 is a partially synthetic data set derived from the observed data.

dataComp(PPA, PPAps1)
}
\keyword{comparison}
\keyword{data}
\keyword{set}
\keyword{synthetic}
