% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ContCI.R
\name{ContCI}
\alias{ContCI}
\title{Confidence intervals and standard errors of multiple imputation for a specific imputed continuous variable.}
\usage{
ContCI(obs_data, imp_data_list, var, sig = 6, alpha = 0.05)
}
\arguments{
\item{obs_data}{The original dataset to which the next will be compared, of the type "data.frame".}

\item{imp_data_list}{A list composed of \code{m} synthetic data sets.}

\item{var}{The continuous variable being checked.}

\item{sig}{The number of significant digits in the output data frame.  Defaults to 6.}

\item{alpha}{Test size, defaults to 0.05.}
}
\value{
This function returns a data frame with the variable's observed mean, lower and upper limits of the confidence interval, standard error, and a YES/NO indicating whether or not the observed value is within the confidence interval.
}
\description{
This function will calculate confidence intervals and standard errors from the responses of multiple imputed datasets for a specified continuous variable, and also give a YES/NO indicator for whether or not the observed value is within the confidence interval.
The confidence intervals and standard errors are calculated by first taking the means of the variable from the partially synthesized datasets, then using \code{t.test()} to get the confidence intervals.
}
\details{
This function was developed with the intention of making the job of researching partially synthetic data utility a bit easier by providing another way of measuring utility.
}
\examples{
#"PPA" is the observed data set
#"PPAm5" is a list of 5 partially synthetic data sets derived from PPA
#"age" is a continuous variable present in the synthesized data sets.
#3 significant digits are desired from the output data frame.

ContCI(PPA, PPAm5, "age", sig=3)
}
\keyword{imputation}
\keyword{multiple}
\keyword{synds}
\keyword{synth}
\keyword{synthetic}
\keyword{utility}
