#' Characteristics of 1000 People in Pennsylvania.
#'
#' A dataset containing some variables about 1000 people in Pennsylvania.  This is a subset of the 2017 ACS PUMS data with one indicator variable added.
#'
#' @format A data frame with 1000 rows and 7 variables:
#' \describe{
#'   \item{age}{age of respondent, in years, ("AGEP")}
#'   \item{sex}{sex of respondent, ("SEX")}
#'   \item{race}{recoded detailed race code, ("RAC1P")}
#'   \item{marriage}{married/spouse present/spouse absent, ("MSP")}
#'   \item{emp}{employment status recode, ("ESR")}
#'   \item{vet}{veteran period of service, ("VPS")}
#'   \item{age17plus}{age >= 17 indicator}
#' }
#' @source \url{https://factfinder.census.gov/faces/tableservices/jsf/pages/productview.xhtml?pid=ACS_pums_csv_2017&prodType=document}
"PPA"

#' Characteristics of 1000 People in Pennsylvania, partially synthetic (set 1).
#'
#' This is a version of the PPA data set that is partially synthetic.  Some of the values of "sex", "marriage", and "age17plus" were imputed.
#'
#' @format A data frame with 1000 rows and 7 variables:
#' \describe{
#'   \item{age}{age of respondent, in years, ("AGEP")}
#'   \item{sex}{sex of respondent, ("SEX")}
#'   \item{race}{recoded detailed race code, ("RAC1P")}
#'   \item{marriage}{married/spouse present/spouse absent, ("MSP")}
#'   \item{emp}{employment status recode, ("ESR")}
#'   \item{vet}{veteran period of service, ("VPS")}
#'   \item{age17plus}{age >= 17 indicator}
#' }
#' @source \url{https://factfinder.census.gov/faces/tableservices/jsf/pages/productview.xhtml?pid=ACS_pums_csv_2017&prodType=document}
"PPAps1"

#' Characteristics of 1000 People in Pennsylvania, partially synthetic (set 2).
#'
#' This is a version of the PPA data set that is partially synthetic.  Some of the values of "sex", "marriage", and "age17plus" were imputed.
#'
#' @format A data frame with 1000 rows and 7 variables:
#' \describe{
#'   \item{age}{age of respondent, in years, ("AGEP")}
#'   \item{sex}{sex of respondent, ("SEX")}
#'   \item{race}{recoded detailed race code, ("RAC1P")}
#'   \item{marriage}{married/spouse present/spouse absent, ("MSP")}
#'   \item{emp}{employment status recode, ("ESR")}
#'   \item{vet}{veteran period of service, ("VPS")}
#'   \item{age17plus}{age >= 17 indicator}
#' }
#' @source \url{https://factfinder.census.gov/faces/tableservices/jsf/pages/productview.xhtml?pid=ACS_pums_csv_2017&prodType=document}
"PPAps2"

#' Characteristics of 1000 People in Pennsylvania, partially synthetic (set 3).
#'
#' This is a version of the PPA data set that is partially synthetic.  Some of the values of "sex", "marriage", and "age17plus" were imputed.
#'
#' @format A data frame with 1000 rows and 7 variables:
#' \describe{
#'   \item{age}{age of respondent, in years, ("AGEP")}
#'   \item{sex}{sex of respondent, ("SEX")}
#'   \item{race}{recoded detailed race code, ("RAC1P")}
#'   \item{marriage}{married/spouse present/spouse absent, ("MSP")}
#'   \item{emp}{employment status recode, ("ESR")}
#'   \item{vet}{veteran period of service, ("VPS")}
#'   \item{age17plus}{age >= 17 indicator}
#' }
#' @source \url{https://factfinder.census.gov/faces/tableservices/jsf/pages/productview.xhtml?pid=ACS_pums_csv_2017&prodType=document}
"PPAps3"

#' Characteristics of 1000 People in Pennsylvania, partially synthetic (set 4).
#'
#' This is a version of the PPA data set that is partially synthetic.  Some of the values of "sex", "marriage", and "age17plus" were imputed.
#'
#' @format A data frame with 1000 rows and 7 variables:
#' \describe{
#'   \item{age}{age of respondent, in years, ("AGEP")}
#'   \item{sex}{sex of respondent, ("SEX")}
#'   \item{race}{recoded detailed race code, ("RAC1P")}
#'   \item{marriage}{married/spouse present/spouse absent, ("MSP")}
#'   \item{emp}{employment status recode, ("ESR")}
#'   \item{vet}{veteran period of service, ("VPS")}
#'   \item{age17plus}{age >= 17 indicator}
#' }
#' @source \url{https://factfinder.census.gov/faces/tableservices/jsf/pages/productview.xhtml?pid=ACS_pums_csv_2017&prodType=document}
"PPAps4"

#' Characteristics of 1000 People in Pennsylvania, partially synthetic (set 5).
#'
#' This is a version of the PPA data set that is partially synthetic.  Some of the values of "sex", "marriage", and "age17plus" were imputed.
#'
#' @format A data frame with 1000 rows and 7 variables:
#' \describe{
#'   \item{age}{age of respondent, in years, ("AGEP")}
#'   \item{sex}{sex of respondent, ("SEX")}
#'   \item{race}{recoded detailed race code, ("RAC1P")}
#'   \item{marriage}{married/spouse present/spouse absent, ("MSP")}
#'   \item{emp}{employment status recode, ("ESR")}
#'   \item{vet}{veteran period of service, ("VPS")}
#'   \item{age17plus}{age >= 17 indicator}
#' }
#' @source \url{https://factfinder.census.gov/faces/tableservices/jsf/pages/productview.xhtml?pid=ACS_pums_csv_2017&prodType=document}
"PPAps5"

#' A list containing 5 partially synthetic data sets.
#'
#' This is a list that has the 5 partially synthetic versions of PPA (PPAps1 - PPAps5).
#'
#' @format 5 data frames with 1000 rows and 7 variables:
#' \describe{
#'   \item{age}{age of respondent, in years, ("AGEP")}
#'   \item{sex}{sex of respondent, ("SEX")}
#'   \item{race}{recoded detailed race code, ("RAC1P")}
#'   \item{marriage}{married/spouse present/spouse absent, ("MSP")}
#'   \item{emp}{employment status recode, ("ESR")}
#'   \item{vet}{veteran period of service, ("VPS")}
#'   \item{age17plus}{age >= 17 indicator}
#' }
#' @source \url{https://factfinder.census.gov/faces/tableservices/jsf/pages/productview.xhtml?pid=ACS_pums_csv_2017&prodType=document}
"PPAm5"
