% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_distance_forest_dataframe.R
\name{predict_distance_forest}
\alias{predict_distance_forest}
\title{Predict Distances Between Samples Based on a Survival Forest Fit (Data Supplied as a Dataframe)}
\usage{
predict_distance_forest(
  survival_forest,
  numeric_predictor,
  factor_predictor,
  data,
  missing = "omit"
)
}
\arguments{
\item{survival_forest}{a fitted survival forest}

\item{numeric_predictor}{a formula specifying the numeric predictors. 
As in \code{~x1+x2+x3}, the three numeric variables \code{x1}, \code{x2}, and \code{x3} are included as numeric predictors. 
\code{x1[i]}, \code{x2[i]}, and \code{x3[i]} are the predictors of the ith sample.
The best practice is to use the same variables names in the training and testing dataset.}

\item{factor_predictor}{a formula specifying the numeric predictors. 
As in \code{~z1+z2+z3}, the three character variables \code{z1}, \code{z2}, and \code{z3} are included as factor predictors. 
\code{z1[i]}, \code{z2[i]}, and \code{z3[i]} are the predictors of the ith sample.
The best practice is to use the same variables names in the training and testing dataset.}

\item{data}{the dataframe (test data) that stores the outcome and predictor variables.
Variables in the global environment will be used if \code{data} is missing.}

\item{missing}{a character value that specifies the handling of missing data. 
If \code{missing=="omit"}, samples with missing values in the splitting variables will be discarded.
If \code{missing=="majority"}, samples with missing values in the splitting variables will be assigned to the majority node.
If \code{missing=="weighted"}, samples with missing values in the splitting variables will be weighted by the weights of branch nodes.
The best practice is to use the same method as the trained random forest.}
}
\value{
A list. 
\code{mean_distance} is the mean distance matrix. 
\code{sum_distance} is the matrix that sums the distances between samples. 
\code{sum_non_na} is the matrix of the number of non NA distances being averaged.
}
\description{
The function 
\code{predict_distance_forest} predicts distances between samples based on a survival forest fit.
}
\details{
Predict Distances Between Samples Based on a Survival Forest Fit (Data Supplied as a Dataframe)
}
\examples{
\donttest{
library(survival)
a_survival_forest<-
  survival_forest(
    survival_outcome=Surv(time,status==2)~1,
    numeric_predictor=~age+ph.ecog+ph.karno+pat.karno+meal.cal,
    factor_predictor=~as.factor(sex),
    data=lung,nboot=20)
a_distance<-
  predict_distance_forest(
    a_survival_forest,
    numeric_predictor=~age+ph.ecog+ph.karno+pat.karno+meal.cal,
    factor_predictor=~as.factor(sex),
    data=lung)
}
}
