\name{rg.robmva}
\alias{rg.robmva}
\title{ Robust Multivariate Analysis }
\description{
  Procedure for multivariate analysis using the minimum volume ellipsoid (MVE), minimum covariance determinant (MCD) or a supplied set of 0-1 weights.
}
\usage{
rg.robmva(x, proc = "mcd", wts = NULL, main = deparse(substitute(x)))
}
\arguments{
  \item{x}{ data }
  \item{proc}{ procedure for the estimation (MVE or MCD) }
  \item{wts}{ if proc=NULL, the supplied weights for the calculation }
  \item{main}{ input for the list }
}
\details{
  cov.mcd is limited to a maximum of 50 variables. Both of these procedures lead to a vector of 0-1 weights and mcd is the default.
  A set of weights can be generated by using Graphical Adaptive Interactive Trimming (GAIT) procedure available though rg.md.gait().
  Using 0-1 weights the parameters of the background distribution are estimated by cov.wt(). A robust estimation of the Mahalanobis distances is made for the total data set but is only undertaken if x is non-singular (lowest eigenvalue is >10e-4).
}
\value{
  \item{n}{number of rows}
  \item{p}{number of columns}
  \item{wts}{the weights for the covariance matrix}
  \item{mean}{the mean of the data}
  \item{cov}{the covariance}
  \item{sd}{the standard deviation}
  \item{r}{correlation matrix}
  \item{eigenvalues}{eigenvalues of the SVD}
  \item{econtrib}{proportion of eigenvalues in \%}
  \item{eigenvectors}{eigenvectors of the SVD}
  \item{rload}{loadings matrix}
  \item{rcr}{standardised loadings matrix}
  \item{vcontrib}{scores variance}
  \item{pvcontrib}{proportion of scores variance in \%}
  \item{cpvcontrib}{cummulative proportion of scores variance}
  \item{md}{Mahalanbois distance}
  \item{ppm}{probability for outliegness using F-distribution}
  \item{epm}{probability for outliegness using Chisquared-distribution}
}
\references{ C. Reimann, P. Filzmoser, R.G. Garrett, and R. Dutter: Statistical Data Analysis
   Explained. Applied Environmental Statistics with R. John Wiley and Sons, Chichester, 2008. }
\author{ Peter Filzmoser <\email{P.Filzmoser@tuwien.ac.at}>
\url{http://cstat.tuwien.ac.at/filz/}}
\examples{
#input data
data(ohorizon)
vegzn=ohorizon[,"VEG_ZONE"]
veg=rep(NA,nrow(ohorizon))
veg[vegzn=="BOREAL_FOREST"] <- 1
veg[vegzn=="FOREST_TUNDRA"] <- 2
veg[vegzn=="SHRUB_TUNDRA"] <- 3
veg[vegzn=="DWARF_SHRUB_TUNDRA"] <- 3
veg[vegzn=="TUNDRA"] <- 3
el=c("Ag","Al","As","B","Ba","Bi","Ca","Cd","Co","Cu","Fe","K","Mg","Mn",
  "Na","Ni","P","Pb","Rb","S","Sb","Sr","Th","Tl","V","Y","Zn")
x <- log10(ohorizon[!is.na(veg),el])
v <- veg[!is.na(veg)]
subvar=c("Ag","B","Bi","Mg","Mn","Na","Pb","Rb","S","Sb","Tl")
set.seed(100)

rg.robmva(as.matrix(x[v==1,subvar]))
}
\keyword{ multivariate }
\keyword{ robust }
